/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.RuleQuery;
import org.apache.shenyu.admin.model.query.SelectorQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.DataPermissionPageVO;
import org.apache.shenyu.admin.service.DataPermissionService;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/data-permission"})
public class DataPermissionController {
    private final DataPermissionService dataPermissionService;

    public DataPermissionController(DataPermissionService dataPermissionService) {
        this.dataPermissionService = dataPermissionService;
    }

    @GetMapping(value={"/selector"})
    public ShenyuAdminResult listPageSelectorDataPermissions(@RequestParam(value="currentPage") Integer currentPage, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="userId") String userId, @RequestParam(value="pluginId") String pluginId, @RequestParam(value="name", required=false) String name) {
        CommonPager<DataPermissionPageVO> selectorList = this.dataPermissionService.listSelectorsByPage(new SelectorQuery(pluginId, name, new PageParameter(currentPage, pageSize)), userId);
        return ShenyuAdminResult.success("query success", selectorList);
    }

    @GetMapping(value={"/rules"})
    public ShenyuAdminResult listPageRuleDataPermissions(@RequestParam(value="currentPage") Integer currentPage, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="userId") String userId, @RequestParam(value="selectorId") String selectorId, @RequestParam(value="name", required=false) String name) {
        CommonPager<DataPermissionPageVO> selectorList = this.dataPermissionService.listRulesByPage(new RuleQuery(selectorId, name, new PageParameter(currentPage, pageSize)), userId);
        return ShenyuAdminResult.success("query success", selectorList);
    }

    @PostMapping(value={"/selector"})
    public ShenyuAdminResult saveSelector(@RequestBody @Valid @NotNull DataPermissionDTO dataPermissionDTO) {
        return ShenyuAdminResult.success("save success", this.dataPermissionService.createSelector(dataPermissionDTO));
    }

    @DeleteMapping(value={"/selector"})
    public ShenyuAdminResult deleteSelector(@RequestBody @Valid @NotNull DataPermissionDTO dataPermissionDTO) {
        return ShenyuAdminResult.success("delete success", this.dataPermissionService.deleteSelector(dataPermissionDTO));
    }

    @PostMapping(value={"/rule"})
    public ShenyuAdminResult saveRule(@RequestBody @Valid @NotNull DataPermissionDTO dataPermissionDTO) {
        return ShenyuAdminResult.success("save success", this.dataPermissionService.createRule(dataPermissionDTO));
    }

    @DeleteMapping(value={"/rule"})
    public ShenyuAdminResult deleteRule(@RequestBody @Valid @NotNull DataPermissionDTO dataPermissionDTO) {
        return ShenyuAdminResult.success("delete success", this.dataPermissionService.deleteRule(dataPermissionDTO));
    }
}

