/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {
    @Value(value="${shenyu.swagger.enable:false}")
    private boolean enable;
    private final BuildProperties buildProperties;

    public SwaggerConfiguration(@Autowired(required=false) BuildProperties buildProperties) {
        this.buildProperties = buildProperties;
    }

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.enable).select().apis(RequestHandlerSelectors.basePackage((String)"org.apache.shenyu.admin.controller")).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        String version = "1.0.0";
        if (this.buildProperties != null) {
            version = this.buildProperties.getVersion();
        }
        return new ApiInfoBuilder().title("Shenyu Admin API Document").description("").version(version).contact(new Contact("shenyu", "https://github.com/apache/incubator-shenyu", "")).build();
    }
}

