/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.InstanceInfo;
import java.net.URI;
import java.util.Map;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.util.Assert;

public class EurekaServiceInstance
implements ServiceInstance {
    private InstanceInfo instance;

    public EurekaServiceInstance(InstanceInfo instance) {
        Assert.notNull((Object)instance, (String)"Service instance required");
        this.instance = instance;
    }

    public InstanceInfo getInstanceInfo() {
        return this.instance;
    }

    public String getInstanceId() {
        return this.instance.getId();
    }

    public String getServiceId() {
        return this.instance.getAppName();
    }

    public String getHost() {
        return this.instance.getHostName();
    }

    public int getPort() {
        if (this.isSecure()) {
            return this.instance.getSecurePort();
        }
        return this.instance.getPort();
    }

    public boolean isSecure() {
        return this.instance.isPortEnabled(InstanceInfo.PortType.SECURE);
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.instance.getMetadata();
    }
}

