/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.tars.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.qq.tars.client.Communicator;
import com.qq.tars.client.CommunicatorConfig;
import com.qq.tars.client.CommunicatorFactory;
import com.qq.tars.protocol.annotation.Servant;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.TarsUpstream;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.tars.exception.ShenyuTarsPluginException;
import org.apache.shenyu.plugin.tars.proxy.TarsInvokePrx;
import org.apache.shenyu.plugin.tars.proxy.TarsInvokePrxList;
import org.apache.shenyu.plugin.tars.util.PrxInfoUtil;
import org.apache.shenyu.plugin.tars.util.ReturnValueResolver;
import org.assertj.core.internal.bytebuddy.ByteBuddy;
import org.assertj.core.internal.bytebuddy.description.annotation.AnnotationDescription;
import org.assertj.core.internal.bytebuddy.description.modifier.ModifierContributor;
import org.assertj.core.internal.bytebuddy.description.modifier.Visibility;
import org.assertj.core.internal.bytebuddy.dynamic.DynamicType;
import org.assertj.core.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private static final ReentrantLock LOCK = new ReentrantLock();
    private final LoadingCache<String, TarsInvokePrxList> cache = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<String, TarsInvokePrxList>(){

        @NonNull
        public TarsInvokePrxList load(@NonNull String key) {
            return new TarsInvokePrxList(null, null, null);
        }
    });
    private final ConcurrentHashMap<String, List<MetaData>> ctxPathCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Class<?>> prxClassCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TarsParamInfo> prxParamCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, List<TarsUpstream>> refreshUpstreamCache = new ConcurrentHashMap();
    private final Communicator communicator = CommunicatorFactory.getInstance().getCommunicator(CommunicatorConfig.getDefault());

    private ApplicationConfigCache() {
    }

    public TarsInvokePrxList get(String path) {
        try {
            return (TarsInvokePrxList)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuTarsPluginException(e.getCause());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initPrx(MetaData metaData) {
        while (true) {
            Class<?> prxClass = this.prxClassCache.get(metaData.getPath());
            try {
                if (!Objects.isNull(prxClass)) {
                    if (!Objects.nonNull(metaData.getContextPath())) return;
                    if (!Objects.nonNull(this.refreshUpstreamCache.get(metaData.getContextPath()))) return;
                    this.refreshTarsInvokePrxList(metaData, this.refreshUpstreamCache.get(metaData.getContextPath()));
                    return;
                }
                this.tryLockedLoadMetaData(metaData);
            }
            catch (Exception e) {
                LOG.error("ShenyuTarsPluginInitializeException: init tars ref ex:{}", (Object)e.getMessage());
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLockedLoadMetaData(MetaData metaData) throws ClassNotFoundException {
        assert (LOCK != null);
        if (LOCK.tryLock()) {
            try {
                if (StringUtils.isEmpty((CharSequence)metaData.getRpcExt())) {
                    throw new ShenyuTarsPluginException("ShenyuTarsPluginInitializeException: can't init prx with empty ext string");
                }
                Class<?> prxClazz = this.buildClassDefinition(metaData);
                this.prxClassCache.put(metaData.getPath(), prxClazz);
                List paths = this.ctxPathCache.getOrDefault(metaData.getContextPath(), new ArrayList());
                if (!IterableUtils.matchesAny((Iterable)paths, p -> p.getPath().equals(metaData.getPath()))) {
                    paths.add(metaData);
                }
                this.ctxPathCache.put(metaData.getContextPath(), paths);
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    private Class<?> buildClassDefinition(MetaData metaData) throws ClassNotFoundException {
        String clazzName = PrxInfoUtil.getPrxName(metaData);
        DynamicType.Builder classDefinition = new ByteBuddy().makeInterface().name(clazzName);
        TarsParamExtInfo tarsParamExtInfo = (TarsParamExtInfo)GsonUtils.getInstance().fromJson(metaData.getRpcExt(), TarsParamExtInfo.class);
        for (MethodInfo methodInfo : tarsParamExtInfo.getMethodInfo()) {
            DynamicType.Builder.MethodDefinition.ParameterDefinition.Initial definition = classDefinition.defineMethod(PrxInfoUtil.getMethodName(methodInfo.methodName), ReturnValueResolver.getCallBackType(PrxInfoUtil.getParamClass(methodInfo.getReturnType())), new ModifierContributor.ForMethod[]{Visibility.PUBLIC});
            if (!CollectionUtils.isNotEmpty(methodInfo.getParams())) continue;
            Class[] paramTypes = new Class[methodInfo.getParams().size()];
            String[] paramNames = new String[methodInfo.getParams().size()];
            for (int i = 0; i < methodInfo.getParams().size(); ++i) {
                Pair<String, String> pair = methodInfo.getParams().get(i);
                paramTypes[i] = PrxInfoUtil.getParamClass((String)pair.getKey());
                paramNames[i] = (String)pair.getValue();
                definition = definition.withParameter((Type)paramTypes[i], paramNames[i], new ModifierContributor.ForParameter[0]);
                this.prxParamCache.put(ApplicationConfigCache.getClassMethodKey(clazzName, methodInfo.getMethodName()), new TarsParamInfo(paramTypes, paramNames));
            }
            classDefinition = definition.withoutCode();
        }
        return classDefinition.annotateType(new AnnotationDescription[]{AnnotationDescription.Builder.ofType(Servant.class).build()}).make().load(Servant.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    public static String getClassMethodKey(String className, String methodName) {
        return String.join((CharSequence)"_", className, methodName);
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void initPrxClass(SelectorData selectorData) {
        try {
            List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), TarsUpstream.class);
            if (CollectionUtils.isEmpty((Collection)upstreamList)) {
                this.invalidate(selectorData.getName());
                return;
            }
            this.refreshUpstreamCache.put(selectorData.getName(), upstreamList);
            List metaDataList = this.ctxPathCache.getOrDefault(selectorData.getName(), new ArrayList());
            for (MetaData metaData : metaDataList) {
                this.refreshTarsInvokePrxList(metaData, upstreamList);
            }
        }
        catch (NoSuchMethodException | ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    private void refreshTarsInvokePrxList(MetaData metaData, List<TarsUpstream> upstreamList) throws NoSuchMethodException, ExecutionException {
        Class<?> prxClass = this.prxClassCache.get(metaData.getPath());
        if (Objects.isNull(prxClass)) {
            return;
        }
        TarsInvokePrxList tarsInvokePrxList = (TarsInvokePrxList)this.cache.get((Object)metaData.getPath());
        tarsInvokePrxList.getTarsInvokePrxList().clear();
        if (Objects.isNull(tarsInvokePrxList.getMethod())) {
            TarsParamInfo tarsParamInfo = this.prxParamCache.get(ApplicationConfigCache.getClassMethodKey(prxClass.getName(), metaData.getMethodName()));
            Object prx = this.communicator.stringToProxy(prxClass, PrxInfoUtil.getObjectName(upstreamList.get(0).getUpstreamUrl(), metaData.getServiceName()));
            Method method = prx.getClass().getDeclaredMethod(PrxInfoUtil.getMethodName(metaData.getMethodName()), tarsParamInfo.getParamTypes());
            tarsInvokePrxList.setMethod(method);
            tarsInvokePrxList.setParamTypes(tarsParamInfo.getParamTypes());
            tarsInvokePrxList.setParamNames(tarsParamInfo.getParamNames());
        }
        tarsInvokePrxList.getTarsInvokePrxList().addAll(upstreamList.stream().map(upstream -> {
            Object strProxy = this.communicator.stringToProxy(prxClass, PrxInfoUtil.getObjectName(upstream.getUpstreamUrl(), metaData.getServiceName()));
            return new TarsInvokePrx(strProxy, upstream.getUpstreamUrl());
        }).collect(Collectors.toList()));
    }

    public void invalidate(String contextPath) {
        List metaDataList = this.ctxPathCache.getOrDefault(contextPath, new ArrayList());
        metaDataList.forEach(metaData -> this.cache.invalidate((Object)metaData.getPath()));
    }

    static class TarsParamInfo {
        private Class<?>[] paramTypes;
        private String[] paramNames;

        TarsParamInfo(Class<?>[] paramTypes, String[] paramNames) {
            this.paramTypes = paramTypes;
            this.paramNames = paramNames;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public void setParamTypes(Class<?>[] paramTypes) {
            this.paramTypes = paramTypes;
        }

        public String[] getParamNames() {
            return this.paramNames;
        }

        public void setParamNames(String[] paramNames) {
            this.paramNames = paramNames;
        }
    }

    static class TarsParamExtInfo {
        private List<MethodInfo> methodInfo;

        TarsParamExtInfo() {
        }

        public List<MethodInfo> getMethodInfo() {
            return this.methodInfo;
        }

        public void setMethodInfo(List<MethodInfo> methodInfo) {
            this.methodInfo = methodInfo;
        }
    }

    static class MethodInfo {
        private String methodName;
        private List<Pair<String, String>> params;
        private String returnType;

        MethodInfo() {
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public List<Pair<String, String>> getParams() {
            return this.params;
        }

        public void setParams(List<Pair<String, String>> params) {
            this.params = params;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

