/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.apache.dubbo.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.DubboRegisterConfig;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboConfigCache;
import org.apache.shenyu.plugin.dubbo.common.cache.DubboParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApacheDubboConfigCache
extends DubboConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApacheDubboConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (Objects.nonNull(config)) {
            config.destroy();
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        @Nonnull
        public ReferenceConfig<GenericService> load(@Nonnull String key) {
            return new ReferenceConfig();
        }
    });

    public static ApacheDubboConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.applicationConfig)) {
            this.applicationConfig = new ApplicationConfig("shenyu_proxy");
        }
        if (this.needUpdateRegistryConfig(dubboRegisterConfig)) {
            RegistryConfig registryConfigTemp = new RegistryConfig();
            registryConfigTemp.setProtocol(dubboRegisterConfig.getProtocol());
            registryConfigTemp.setId("shenyu_proxy");
            registryConfigTemp.setRegister(Boolean.valueOf(false));
            registryConfigTemp.setAddress(dubboRegisterConfig.getRegister());
            Optional.ofNullable(dubboRegisterConfig.getGroup()).ifPresent(arg_0 -> ((RegistryConfig)registryConfigTemp).setGroup(arg_0));
            this.registryConfig = registryConfigTemp;
        }
    }

    private boolean needUpdateRegistryConfig(DubboRegisterConfig dubboRegisterConfig) {
        if (Objects.isNull(this.registryConfig)) {
            return true;
        }
        return !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol()) || !Objects.equals(dubboRegisterConfig.getRegister(), this.registryConfig.getAddress()) || !Objects.equals(dubboRegisterConfig.getProtocol(), this.registryConfig.getProtocol());
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init dubbo ref exception", (Throwable)e);
        }
        return this.build(metaData);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ReferenceConfig();
        }
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.setAsync(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        reference.setCheck(Boolean.valueOf(false));
        reference.setLoadbalance("gray");
        HashMap<String, String> parameters = new HashMap<String, String>(2);
        parameters.put("dispatcher", "direct");
        reference.setParameters(parameters);
        String rpcExt = metaData.getRpcExt();
        DubboParam dubboParam = this.parserToDubboParam(rpcExt);
        if (Objects.nonNull(dubboParam)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getVersion()})) {
                reference.setVersion(dubboParam.getVersion());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getGroup()})) {
                reference.setGroup(dubboParam.getGroup());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getUrl()})) {
                reference.setUrl(dubboParam.getUrl());
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParam.getCluster()})) {
                reference.setCluster(dubboParam.getCluster());
            }
            Optional.ofNullable(dubboParam.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(dubboParam.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
            Optional.ofNullable(dubboParam.getSent()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setSent(arg_0));
        }
        try {
            Object obj = reference.get();
            if (Objects.nonNull(obj)) {
                LOG.info("init apache dubbo reference success there meteData is :{}", (Object)metaData);
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            LOG.error("init apache dubbo reference exception", (Throwable)e);
        }
        return reference;
    }

    public ReferenceConfig<GenericService> get(String path) {
        try {
            return (ReferenceConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static final class ApplicationConfigCacheInstance {
        static final ApacheDubboConfigCache INSTANCE = new ApacheDubboConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

