/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sync.data.websocket.client;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.shenyu.common.dto.WebsocketData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.sync.data.websocket.handler.WebsocketDataHandler;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuWebsocketClient
extends WebSocketClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuWebsocketClient.class);
    private volatile boolean alreadySync = Boolean.FALSE;
    private final WebsocketDataHandler websocketDataHandler;
    private final ScheduledThreadPoolExecutor executor;

    public ShenyuWebsocketClient(URI serverUri, PluginDataSubscriber pluginDataSubscriber, List<MetaDataSubscriber> metaDataSubscribers, List<AuthDataSubscriber> authDataSubscribers, ScheduledThreadPoolExecutor executor) {
        super(serverUri);
        this.websocketDataHandler = new WebsocketDataHandler(pluginDataSubscriber, metaDataSubscribers, authDataSubscribers);
        this.executor = executor;
        this.connection();
    }

    private void connection() {
        this.executor.scheduleAtFixedRate(this::healthCheck, 10L, 10L, TimeUnit.SECONDS);
        this.connectBlocking();
    }

    public boolean connectBlocking() {
        boolean success = false;
        try {
            success = super.connectBlocking();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (success) {
            LOG.info("websocket connection server[{}] is successful.....", (Object)this.getURI().toString());
        } else {
            LOG.warn("websocket connection server[{}] is error.....", (Object)this.getURI().toString());
        }
        return success;
    }

    public void onOpen(ServerHandshake serverHandshake) {
        if (!this.alreadySync) {
            this.send(DataEventTypeEnum.MYSELF.name());
            this.alreadySync = true;
        }
    }

    public void onMessage(String result) {
        this.handleResult(result);
    }

    public void onClose(int i, String s, boolean b) {
        this.close();
    }

    public void onError(Exception e) {
        this.close();
    }

    public void close() {
        this.alreadySync = false;
        if (this.isOpen()) {
            super.close();
        }
    }

    private void healthCheck() {
        try {
            if (!this.isOpen()) {
                this.reconnectBlocking();
            } else {
                this.sendPing();
                LOG.debug("websocket send to [{}] ping message successful", (Object)this.getURI().toString());
            }
        }
        catch (Exception e) {
            LOG.error("websocket connect is error :{}", (Object)e.getMessage());
        }
    }

    private void handleResult(String result) {
        LOG.info("handleResult({})", (Object)result);
        WebsocketData websocketData = (WebsocketData)GsonUtils.getInstance().fromJson(result, WebsocketData.class);
        ConfigGroupEnum groupEnum = ConfigGroupEnum.acquireByName((String)websocketData.getGroupType());
        String eventType = websocketData.getEventType();
        String json = GsonUtils.getInstance().toJson((Object)websocketData.getData());
        this.websocketDataHandler.executor(groupEnum, json, eventType);
    }
}

