/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.dependencies.io.opentracing.util;

import java.util.concurrent.Callable;
import org.apache.shenyu.dependencies.io.opentracing.Scope;
import org.apache.shenyu.dependencies.io.opentracing.ScopeManager;
import org.apache.shenyu.dependencies.io.opentracing.Span;
import org.apache.shenyu.dependencies.io.opentracing.SpanContext;
import org.apache.shenyu.dependencies.io.opentracing.Tracer;
import org.apache.shenyu.dependencies.io.opentracing.noop.NoopTracerFactory;
import org.apache.shenyu.dependencies.io.opentracing.propagation.Format;

public final class GlobalTracer
implements Tracer {
    private static final GlobalTracer INSTANCE = new GlobalTracer();
    private static volatile Tracer tracer = NoopTracerFactory.create();
    private static volatile boolean isRegistered = false;

    private GlobalTracer() {
    }

    public static Tracer get() {
        return INSTANCE;
    }

    public static boolean isRegistered() {
        return isRegistered;
    }

    public static synchronized boolean registerIfAbsent(Callable<Tracer> provider) {
        GlobalTracer.requireNonNull(provider, "Cannot register GlobalTracer from provider <null>.");
        if (!GlobalTracer.isRegistered()) {
            try {
                Tracer suppliedTracer = GlobalTracer.requireNonNull(provider.call(), "Cannot register GlobalTracer <null>.");
                if (!(suppliedTracer instanceof GlobalTracer)) {
                    tracer = suppliedTracer;
                    isRegistered = true;
                    return true;
                }
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Exception obtaining tracer from provider: " + ex.getMessage(), ex);
            }
        }
        return false;
    }

    public static synchronized boolean registerIfAbsent(final Tracer tracer) {
        GlobalTracer.requireNonNull(tracer, "Cannot register GlobalTracer. Tracer is null");
        return GlobalTracer.registerIfAbsent(new Callable<Tracer>(){

            @Override
            public Tracer call() {
                return tracer;
            }
        });
    }

    @Deprecated
    public static void register(Tracer tracer) {
        if (!(GlobalTracer.registerIfAbsent(GlobalTracer.provide(tracer)) || tracer.equals(GlobalTracer.tracer) || tracer instanceof GlobalTracer)) {
            throw new IllegalStateException("There is already a current global Tracer registered.");
        }
    }

    @Override
    public ScopeManager scopeManager() {
        return tracer.scopeManager();
    }

    @Override
    public Tracer.SpanBuilder buildSpan(String operationName) {
        return tracer.buildSpan(operationName);
    }

    @Override
    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        tracer.inject(spanContext, format, carrier);
    }

    @Override
    public <C> SpanContext extract(Format<C> format, C carrier) {
        return tracer.extract(format, carrier);
    }

    @Override
    public Span activeSpan() {
        return tracer.activeSpan();
    }

    @Override
    public Scope activateSpan(Span span) {
        return tracer.activateSpan(span);
    }

    @Override
    public void close() {
        tracer.close();
    }

    public String toString() {
        return GlobalTracer.class.getSimpleName() + '{' + tracer + '}';
    }

    private static Callable<Tracer> provide(final Tracer tracer) {
        return new Callable<Tracer>(){

            @Override
            public Tracer call() {
                return tracer;
            }
        };
    }

    private static <T> T requireNonNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }
}

