/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.jaeger.span;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shenyu.agent.plugin.tracing.jaeger.span.JaegerErrorSpan;
import org.apache.shenyu.dependencies.io.opentracing.Scope;
import org.apache.shenyu.dependencies.io.opentracing.Span;
import org.apache.shenyu.dependencies.io.opentracing.Tracer;
import org.apache.shenyu.dependencies.io.opentracing.util.GlobalTracer;
import org.springframework.web.server.ServerWebExchange;

public class JaegerSpanManager {
    private final List<Scope> scopeList = new LinkedList<Scope>();
    private volatile Span lastSpan;
    private final AtomicInteger count = new AtomicInteger(0);

    public Span add(String buildSpan, Map<String, String> tagMap) {
        Tracer tracer = GlobalTracer.get();
        Tracer.SpanBuilder spanBuilder = tracer.buildSpan(buildSpan);
        if (Objects.nonNull(this.lastSpan)) {
            spanBuilder.asChildOf(this.lastSpan);
        } else {
            spanBuilder.ignoreActiveSpan();
        }
        tagMap.forEach(spanBuilder::withTag);
        Span span = spanBuilder.start();
        Scope scope = tracer.scopeManager().activate(span);
        this.lastSpan = span;
        this.count.incrementAndGet();
        this.scopeList.add(scope);
        return this.lastSpan;
    }

    public void finish(Span span, ServerWebExchange exchange) {
        span.finish();
        if (this.count.decrementAndGet() == 0) {
            this.scopeList.forEach(Scope::close);
            exchange.getAttributes().remove("/shenyu/root");
        }
    }

    public void error(Span span, ServerWebExchange exchange, Throwable throwable) {
        JaegerErrorSpan.setError(span, throwable);
        this.finish(span, exchange);
    }
}

