/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.jaeger.handler;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Optional;
import org.apache.shenyu.agent.api.entity.MethodResult;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.agent.plugin.tracing.jaeger.span.JaegerSpanManager;
import org.apache.shenyu.dependencies.io.opentracing.Span;
import org.apache.shenyu.dependencies.io.opentracing.tag.Tags;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public final class JaegerGlobalPluginHandler
implements InstanceMethodHandler {
    @Override
    public void before(TargetObject target, Method method, Object[] args, MethodResult result) {
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        JaegerSpanManager jaegerSpanManager = exchange.getAttributes().getOrDefault("/shenyu/root", new JaegerSpanManager());
        HashMap<String, String> tagMap = new HashMap<String, String>(4);
        tagMap.put(Tags.COMPONENT.getKey(), "shenyu");
        tagMap.put(Tags.HTTP_URL.getKey(), exchange.getRequest().getURI().toString());
        Optional.ofNullable(exchange.getRequest().getMethod()).ifPresent(v -> tagMap.put(Tags.HTTP_STATUS.getKey(), v.toString()));
        Span span = jaegerSpanManager.add("/shenyu/root", tagMap);
        exchange.getAttributes().put("/shenyu/root", jaegerSpanManager);
        target.setContext(span);
    }

    @Override
    public Object after(TargetObject target, Method method, Object[] args, MethodResult methodResult, Object result) {
        Span span = (Span)target.getContext();
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        JaegerSpanManager manager = (JaegerSpanManager)exchange.getAttributes().get("/shenyu/root");
        if (result instanceof Mono) {
            return ((Mono)result).doFinally(s -> manager.finish(span, exchange));
        }
        manager.finish(span, exchange);
        return result;
    }

    @Override
    public void onThrowing(TargetObject target, Method method, Object[] args, Throwable throwable) {
        Span span = (Span)target.getContext();
        ServerWebExchange exchange = (ServerWebExchange)args[0];
        JaegerSpanManager manager = (JaegerSpanManager)exchange.getAttributes().get("/shenyu/root");
        manager.error(span, exchange, throwable);
    }
}

