/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.jaeger.boot;

import io.jaegertracing.Configuration;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.agent.api.config.AgentPluginConfig;
import org.apache.shenyu.agent.api.exception.ShenyuAgentException;
import org.apache.shenyu.agent.api.spi.AgentPluginBootService;
import org.apache.shenyu.dependencies.io.opentracing.util.GlobalTracer;
import org.apache.shenyu.spi.Join;

@Join
public class JaegerAgentPluginBootService
implements AgentPluginBootService {
    private Configuration configuration;

    @Override
    public void start(AgentPluginConfig agentPluginConfig) {
        if (StringUtils.isEmpty((CharSequence)agentPluginConfig.getHost()) || agentPluginConfig.getPort() < 0) {
            throw new ShenyuAgentException("jaeger config error, host can not config or port is %s", agentPluginConfig.getPort());
        }
        agentPluginConfig.getProps().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> System.setProperty(String.valueOf(key), String.valueOf(value))));
        Configuration.SamplerConfiguration samplerConfig = Configuration.SamplerConfiguration.fromEnv();
        Configuration.ReporterConfiguration reporterConfig = Configuration.ReporterConfiguration.fromEnv().withSender(Configuration.SenderConfiguration.fromEnv().withAgentHost(agentPluginConfig.getHost()).withAgentPort(agentPluginConfig.getPort()));
        String serviceName = Optional.ofNullable(agentPluginConfig.getProps().getProperty("SERVICE_NAME")).orElse("shenyu-agent");
        this.configuration = new Configuration(serviceName).withSampler(samplerConfig).withReporter(reporterConfig);
        if (!GlobalTracer.isRegistered()) {
            GlobalTracer.registerIfAbsent(this.configuration.getTracer());
        }
    }

    @Override
    public void close() {
        Optional.ofNullable(this.configuration).ifPresent(Configuration::closeTracer);
    }
}

