/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.sync.data.http;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.http.HttpSyncDataService;
import org.apache.shenyu.sync.data.http.config.HttpConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={HttpSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.http", name={"url"})
public class HttpSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpSyncDataConfiguration.class);

    @Bean
    public SyncDataService httpSyncDataService(ObjectProvider<HttpConfig> httpConfig, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers) {
        LOGGER.info("you use http long pull sync shenyu data");
        return new HttpSyncDataService((HttpConfig)Objects.requireNonNull(httpConfig.getIfAvailable()), (PluginDataSubscriber)Objects.requireNonNull(pluginSubscriber.getIfAvailable()), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    @ConfigurationProperties(prefix="shenyu.sync.http")
    public HttpConfig httpConfig() {
        return new HttpConfig();
    }
}

