/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.uri;

import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.utils.RequestQueryCodecUtil;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class URIPlugin
implements ShenyuPlugin {
    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        assert (shenyuContext != null);
        String path = (String)exchange.getAttribute("httpDomain");
        if (StringUtils.isBlank((CharSequence)path)) {
            return chain.execute(exchange);
        }
        String rewriteUri = (String)exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteUri})) {
            path = path + rewriteUri;
        } else {
            String realUrl = shenyuContext.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = path + realUrl;
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{exchange.getRequest().getURI().getQuery()})) {
            path = String.join((CharSequence)"?", path, RequestQueryCodecUtil.getCodecQuery((ServerWebExchange)exchange));
        }
        exchange.getAttributes().put("httpUri", URI.create(path));
        return chain.execute(exchange);
    }

    public int getOrder() {
        return PluginEnum.URI.getCode();
    }

    public String named() {
        return PluginEnum.URI.getName();
    }

    public boolean skip(ServerWebExchange exchange) {
        return this.skipExceptHttpLike(exchange);
    }
}

