/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.selector;

import java.util.Objects;

public final class WebSocketUpstream {
    private String host;
    private String protocol;
    private String url;
    private int weight;
    private boolean status;
    private long timestamp;
    private int warmup;

    private WebSocketUpstream(Builder builder) {
        this.host = builder.host;
        this.protocol = builder.protocol;
        this.url = builder.url;
        this.weight = builder.weight;
        this.status = builder.status;
        this.timestamp = builder.timestamp;
        this.warmup = builder.warmup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getWarmup() {
        return this.warmup;
    }

    public void setWarmup(int warmup) {
        this.warmup = warmup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketUpstream that = (WebSocketUpstream)o;
        return Objects.equals(this.host, that.host) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.url, that.url);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.protocol, this.url);
    }

    public String toString() {
        return "DivideUpstream{host='" + this.host + '\'' + ", protocol='" + this.protocol + '\'' + ", url='" + this.url + '\'' + ", weight=" + this.weight + ", status=" + this.status + ", timestamp=" + this.timestamp + ", warmup=" + this.warmup + '}';
    }

    public static final class Builder {
        private String host;
        private String protocol;
        private String url;
        private int weight;
        private boolean status;
        private long timestamp;
        private int warmup;

        private Builder() {
        }

        public WebSocketUpstream build() {
            return new WebSocketUpstream(this);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder upstreamUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder status(boolean status) {
            this.status = status;
            return this;
        }

        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder warmup(int warmup) {
            this.warmup = warmup;
            return this;
        }
    }
}

