/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.hystrix.handler;

import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.HystrixHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;

public class HystrixPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, HystrixHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerRule(RuleData ruleData) {
        HystrixPropertiesFactory.reset();
        Optional.ofNullable(ruleData.getHandle()).ifPresent(rule -> {
            HystrixHandle hystrixHandle = (HystrixHandle)GsonUtils.getInstance().fromJson(rule, HystrixHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)hystrixHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(rule -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.HYSTRIX.getName();
    }
}

