/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.handler;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.RateLimiterHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RedisModeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.ratelimiter.config.RateLimiterConfig;
import org.apache.shenyu.plugin.ratelimiter.handler.ShenyuReactiveRedisTemplate;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RateLimiterPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, RateLimiterHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            RateLimiterConfig rateLimiterConfig = (RateLimiterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), RateLimiterConfig.class);
            if (Objects.isNull(Singleton.INST.get(ReactiveRedisTemplate.class)) || Objects.isNull(Singleton.INST.get(RateLimiterConfig.class)) || !rateLimiterConfig.equals(Singleton.INST.get(RateLimiterConfig.class))) {
                LettuceConnectionFactory lettuceConnectionFactory = this.createLettuceConnectionFactory(rateLimiterConfig);
                lettuceConnectionFactory.afterPropertiesSet();
                StringRedisSerializer serializer = new StringRedisSerializer();
                RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key((RedisSerializer)serializer).value((RedisSerializer)serializer).hashKey((RedisSerializer)serializer).hashValue((RedisSerializer)serializer).build();
                ShenyuReactiveRedisTemplate reactiveRedisTemplate = new ShenyuReactiveRedisTemplate((ReactiveRedisConnectionFactory)lettuceConnectionFactory, serializationContext);
                Singleton.INST.single(ReactiveRedisTemplate.class, reactiveRedisTemplate);
                Singleton.INST.single(RateLimiterConfig.class, (Object)rateLimiterConfig);
            }
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            RateLimiterHandle rateLimiterHandle = (RateLimiterHandle)GsonUtils.getInstance().fromJson(s, RateLimiterHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)rateLimiterHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData)));
    }

    public String pluginNamed() {
        return PluginEnum.RATE_LIMITER.getName();
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(RateLimiterConfig rateLimiterConfig) {
        LettuceClientConfiguration lettuceClientConfiguration = this.getLettuceClientConfiguration(rateLimiterConfig);
        if (RedisModeEnum.SENTINEL.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisSentinelConfiguration(rateLimiterConfig), lettuceClientConfiguration);
        }
        if (RedisModeEnum.CLUSTER.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisClusterConfiguration(rateLimiterConfig), lettuceClientConfiguration);
        }
        return new LettuceConnectionFactory(this.redisStandaloneConfiguration(rateLimiterConfig), lettuceClientConfiguration);
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(RateLimiterConfig rateLimiterConfig) {
        return LettucePoolingClientConfiguration.builder().poolConfig(this.getPoolConfig(rateLimiterConfig)).build();
    }

    private GenericObjectPoolConfig<?> getPoolConfig(RateLimiterConfig rateLimiterConfig) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(rateLimiterConfig.getMaxActive());
        config.setMaxIdle(rateLimiterConfig.getMaxIdle());
        config.setMinIdle(rateLimiterConfig.getMinIdle());
        if (rateLimiterConfig.getMaxWait() != null) {
            config.setMaxWaitMillis(rateLimiterConfig.getMaxWait().toMillis());
        }
        return config;
    }

    protected final RedisStandaloneConfiguration redisStandaloneConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        String[] parts = StringUtils.split((String)rateLimiterConfig.getUrl(), (String)":");
        assert (parts != null);
        config.setHostName(parts[0]);
        config.setPort(Integer.parseInt(parts[1]));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private RedisClusterConfiguration redisClusterConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.setClusterNodes(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        return config;
    }

    private RedisSentinelConfiguration redisSentinelConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(rateLimiterConfig.getMaster());
        config.setSentinels(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private List<RedisNode> createRedisNode(String url) {
        ArrayList<RedisNode> redisNodes = new ArrayList<RedisNode>();
        ArrayList nodes = Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)url));
        for (String node : nodes) {
            String[] parts = StringUtils.split((String)node, (String)":");
            Assert.state((Objects.requireNonNull(parts).length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
            redisNodes.add(new RedisNode(parts[0], Integer.parseInt(parts[1])));
        }
        return redisNodes;
    }
}

