/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.monitor.handler;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.metrics.config.MetricsConfig;
import org.apache.shenyu.metrics.facade.MetricsTrackerFacade;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;

public class MonitorPluginDataHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            MetricsConfig monitorConfig = (MetricsConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), MetricsConfig.class);
            if (!this.checkConfig(monitorConfig)) {
                return;
            }
            if (!MetricsTrackerFacade.getInstance().isStarted()) {
                this.start(monitorConfig);
            } else if (!monitorConfig.equals(Singleton.INST.get(MetricsConfig.class))) {
                this.restart(monitorConfig);
            }
        } else {
            this.stop();
        }
    }

    public String pluginNamed() {
        return PluginEnum.MONITOR.getName();
    }

    private boolean checkConfig(MetricsConfig monitorConfig) {
        return Objects.nonNull(monitorConfig) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{monitorConfig.getHost()}) && Objects.nonNull(monitorConfig.getPort()) && Objects.nonNull(monitorConfig.getAsync());
    }

    private void restart(MetricsConfig monitorConfig) {
        this.stop();
        this.start(monitorConfig);
    }

    private void start(MetricsConfig monitorConfig) {
        MetricsTrackerFacade.getInstance().start(monitorConfig);
        Singleton.INST.single(MetricsConfig.class, (Object)monitorConfig);
    }

    private void stop() {
        MetricsTrackerFacade.getInstance().stop();
    }
}

