/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.proxy;

import com.alipay.hessian.generic.model.GenericObject;
import com.alipay.sofa.rpc.api.GenericService;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.invoke.SofaResponseCallback;
import com.alipay.sofa.rpc.core.request.RequestBase;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.ResultEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.plugin.sofa.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.sofa.param.SofaParamResolveService;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SofaProxyService {
    private final SofaParamResolveService sofaParamResolveService;

    public SofaProxyService(SofaParamResolveService sofaParamResolveService) {
        this.sofaParamResolveService = sofaParamResolveService;
    }

    public Mono<Object> genericInvoker(String body, MetaData metaData, ServerWebExchange exchange) throws ShenyuException {
        ConsumerConfig<GenericService> reference = ApplicationConfigCache.getInstance().get(metaData.getPath());
        if (Objects.isNull(reference) || StringUtils.isEmpty((CharSequence)reference.getInterfaceId())) {
            ApplicationConfigCache.getInstance().invalidate(metaData.getPath());
            reference = ApplicationConfigCache.getInstance().initRef(metaData);
        }
        Pair<String[], Object[]> pair = StringUtils.isBlank((CharSequence)metaData.getParameterTypes()) || this.parameterIsNone(body) ? new Pair<String[], Object[]>((Object)new String[0], (Object)new Object[0]) : this.sofaParamResolveService.buildParameter(body, metaData.getParameterTypes());
        final CompletableFuture future = new CompletableFuture();
        RpcInvokeContext.getContext().setResponseCallback((SofaResponseCallback)new SofaResponseCallback<Object>(){

            public void onAppResponse(Object o, String s, RequestBase requestBase) {
                future.complete(o);
            }

            public void onAppException(Throwable throwable, String s, RequestBase requestBase) {
                future.completeExceptionally(throwable);
            }

            public void onSofaException(SofaRpcException e, String s, RequestBase requestBase) {
                future.completeExceptionally((Throwable)e);
            }
        });
        GenericService genericService = (GenericService)reference.refer();
        genericService.$genericInvoke(metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight());
        return Mono.fromFuture((CompletableFuture)future.thenApply(ret -> {
            if (Objects.isNull(ret)) {
                ret = "sofa has not return value!";
            }
            GenericObject genericObject = (GenericObject)ret;
            exchange.getAttributes().put("rpc_result", genericObject.getFields());
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
            return ret;
        })).onErrorMap(ShenyuException::new);
    }

    private boolean parameterIsNone(String parameterBody) {
        return null == parameterBody || "".equals(parameterBody) || "{}".equals(parameterBody) || "null".equals(parameterBody);
    }
}

