/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.sofa.cache;

import com.alipay.sofa.rpc.api.GenericService;
import com.alipay.sofa.rpc.config.ApplicationConfig;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.convert.plugin.SofaRegisterConfig;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private final LoadingCache<String, ConsumerConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumSize(1000L).removalListener(notification -> {
        if (notification.getValue() != null) {
            try {
                Class<?> cz = notification.getValue().getClass();
                Field field = FieldUtils.getDeclaredField(cz, (String)"consumerBootstrap", (boolean)true);
                FieldUtils.writeField((Field)field, (Object)notification.getValue(), null);
            }
            catch (IllegalAccessException e) {
                LOG.error("modify ref have exception", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ConsumerConfig<GenericService>>(){

        @NonNull
        public ConsumerConfig<GenericService> load(@NonNull String key) {
            return new ConsumerConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(SofaRegisterConfig sofaRegisterConfig) {
        String shenyuProxy = "shenyu_proxy";
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig();
            this.applicationConfig.setAppId("shenyu_proxy");
            this.applicationConfig.setAppName("shenyu_proxy");
        }
        if (this.registryConfig == null) {
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setProtocol(sofaRegisterConfig.getProtocol());
            this.registryConfig.setId("shenyu_proxy");
            this.registryConfig.setRegister(false);
            this.registryConfig.setAddress(sofaRegisterConfig.getRegister());
        }
    }

    public ConsumerConfig<GenericService> initRef(MetaData metaData) {
        try {
            ConsumerConfig referenceConfig = (ConsumerConfig)this.cache.get((Object)metaData.getPath());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterfaceId()})) {
                return referenceConfig;
            }
        }
        catch (ExecutionException e) {
            LOG.error("init sofa ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public ConsumerConfig<GenericService> build(MetaData metaData) {
        if (Objects.isNull(this.applicationConfig) || Objects.isNull(this.registryConfig)) {
            return new ConsumerConfig();
        }
        ConsumerConfig reference = new ConsumerConfig();
        reference.setGeneric(true);
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterfaceId(metaData.getServiceName());
        reference.setProtocol("bolt");
        reference.setInvokeType("callback");
        reference.setRepeatedReferLimit(-1);
        String rpcExt = metaData.getRpcExt();
        SofaParamExtInfo sofaParamExtInfo = (SofaParamExtInfo)GsonUtils.getInstance().fromJson(rpcExt, SofaParamExtInfo.class);
        if (Objects.nonNull(sofaParamExtInfo)) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sofaParamExtInfo.getLoadbalance()})) {
                String loadBalance = sofaParamExtInfo.getLoadbalance();
                reference.setLoadBalancer(this.buildLoadBalanceName(loadBalance));
            }
            Optional.ofNullable(sofaParamExtInfo.getTimeout()).ifPresent(arg_0 -> ((ConsumerConfig)reference).setTimeout(arg_0));
            Optional.ofNullable(sofaParamExtInfo.getRetries()).ifPresent(arg_0 -> ((ConsumerConfig)reference).setRetries(arg_0));
        }
        try {
            Object obj = reference.refer();
            if (obj != null) {
                LOG.info("init sofa reference success there meteData is :{}", (Object)metaData);
                this.cache.put((Object)metaData.getPath(), (Object)reference);
            }
        }
        catch (Exception e) {
            LOG.error("init sofa reference exception", (Throwable)e);
            e.printStackTrace();
        }
        return reference;
    }

    private String buildLoadBalanceName(String loadBalance) {
        if (LoadBalanceEnum.HASH.getName().equals(loadBalance) || StringUtils.equalsIgnoreCase((CharSequence)"consistenthash", (CharSequence)loadBalance)) {
            return "consistentHash";
        }
        if (LoadBalanceEnum.ROUND_ROBIN.getName().equals(loadBalance) || StringUtils.equalsIgnoreCase((CharSequence)"roundrobin", (CharSequence)loadBalance)) {
            return "roundRobin";
        }
        return loadBalance;
    }

    public ConsumerConfig<GenericService> get(String path) {
        try {
            return (ConsumerConfig)this.cache.get((Object)path);
        }
        catch (ExecutionException e) {
            throw new ShenyuException(e.getCause());
        }
    }

    public void invalidate(String path) {
        this.cache.invalidate((Object)path);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static class SofaParamExtInfo {
        private String loadbalance;
        private Integer retries;
        private Integer timeout;

        SofaParamExtInfo() {
        }

        public String getLoadbalance() {
            return this.loadbalance;
        }

        public void setLoadbalance(String loadbalance) {
            this.loadbalance = loadbalance;
        }

        public Integer getRetries() {
            return this.retries;
        }

        public void setRetries(Integer retries) {
            this.retries = retries;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }

    static final class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        private ApplicationConfigCacheInstance() {
        }
    }
}

