/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.httpclient;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.httpclient.NettyHttpClientPlugin;
import org.apache.shenyu.plugin.httpclient.WebClientPlugin;
import org.apache.shenyu.plugin.httpclient.config.HttpClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

@Configuration
public class HttpClientPluginConfiguration {
    @Bean
    @ConfigurationProperties(prefix="shenyu.httpclient")
    public HttpClientProperties httpClientProperties() {
        return new HttpClientProperties();
    }

    @Bean
    public HttpClient httpClient(HttpClientProperties properties) {
        HttpClientProperties.Pool pool = properties.getPool();
        ConnectionProvider connectionProvider = pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED ? ConnectionProvider.newConnection() : (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED ? ConnectionProvider.fixed((String)pool.getName(), (int)pool.getMaxConnections(), (long)pool.getAcquireTimeout(), (Duration)pool.getMaxIdleTime()) : ConnectionProvider.elastic((String)pool.getName(), (Duration)pool.getMaxIdleTime()));
        HttpClient httpClient = HttpClient.create((ConnectionProvider)connectionProvider).tcpConfiguration(tcpClient -> {
            HttpClientProperties.Proxy proxy;
            if (Objects.nonNull(properties.getConnectTimeout())) {
                tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)properties.getConnectTimeout());
            }
            if (StringUtils.isNotEmpty((CharSequence)(proxy = properties.getProxy()).getHost())) {
                tcpClient = tcpClient.proxy(proxySpec -> {
                    ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxy.getHost());
                    PropertyMapper map = PropertyMapper.get();
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getPort()).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getUsername()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getPassword()).whenHasText().to(password -> builder.password(s -> password));
                    map.from(() -> ((HttpClientProperties.Proxy)proxy).getNonProxyHostsPattern()).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
                });
            }
            tcpClient = tcpClient.doOnConnected(connection -> {
                connection.addHandlerLast((ChannelHandler)new IdleStateHandler((long)properties.getReaderIdleTime().intValue(), (long)properties.getWriterIdleTime().intValue(), (long)properties.getAllIdleTime().intValue(), TimeUnit.MILLISECONDS));
                connection.addHandlerLast((ChannelHandler)new WriteTimeoutHandler((long)properties.getWriteTimeout().intValue(), TimeUnit.MILLISECONDS));
                connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler((long)properties.getReadTimeout().intValue(), TimeUnit.MILLISECONDS));
            });
            return tcpClient;
        });
        HttpClientProperties.Ssl ssl = properties.getSsl();
        if (StringUtils.isNotEmpty((CharSequence)ssl.getKeyStorePath()) || ArrayUtils.isNotEmpty((Object[])ssl.getTrustedX509CertificatesForTrustManager()) || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                Object[] trustedX509Certificates = ssl.getTrustedX509CertificatesForTrustManager();
                if (ArrayUtils.isNotEmpty((Object[])trustedX509Certificates)) {
                    sslContextBuilder.trustManager((X509Certificate[])trustedX509Certificates);
                } else if (ssl.isUseInsecureTrustManager()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                sslContextBuilder.keyManager(ssl.getKeyManagerFactory());
                sslContextSpec.sslContext(sslContextBuilder).defaultConfiguration(ssl.getDefaultConfigurationType()).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
            });
        }
        if (properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        return httpClient.keepAlive(properties.isKeepAlive());
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="netty")
    static class NettyHttpClientConfiguration {
        NettyHttpClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin nettyHttpClientPlugin(ObjectProvider<HttpClient> httpClient) {
            return new NettyHttpClientPlugin((HttpClient)httpClient.getIfAvailable());
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="webClient", matchIfMissing=true)
    static class WebClientConfiguration {
        WebClientConfiguration() {
        }

        @Bean
        public ShenyuPlugin webClientPlugin(ObjectProvider<HttpClient> httpClient) {
            WebClient webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector((HttpClient)Objects.requireNonNull(httpClient.getIfAvailable()))).build();
            return new WebClientPlugin(webClient);
        }
    }
}

