/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.zookeeper;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.InstanceRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.spi.Join;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ZookeeperInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperInstanceRegisterRepository.class);
    private ZkClient zkClient;
    private final Map<String, String> nodeDataMap = new HashMap<String, String>();

    public void init(ShenyuConfig.InstanceConfig config) {
        Properties props = config.getProps();
        int sessionTimeout = Integer.parseInt(props.getProperty("sessionTimeout", "3000"));
        int connectionTimeout = Integer.parseInt(props.getProperty("connectionTimeout", "3000"));
        this.zkClient = new ZkClient(config.getServerLists(), sessionTimeout, connectionTimeout);
        this.zkClient.subscribeStateChanges((IZkStateListener)new ZkStateListener());
    }

    public void persistInstance(InstanceRegisterDTO instance) {
        String realNode;
        String uriNodeName = this.buildInstanceNodeName(instance);
        String instancePath = RegisterPathConstants.buildInstanceParentPath();
        if (!this.zkClient.exists(instancePath)) {
            this.zkClient.createPersistent(instancePath, true);
        }
        if (!this.zkClient.exists(realNode = RegisterPathConstants.buildRealNode((String)instancePath, (String)uriNodeName))) {
            String nodeData = GsonUtils.getInstance().toJson((Object)instance);
            this.nodeDataMap.put(realNode, nodeData);
            this.zkClient.createEphemeral(realNode, (Object)nodeData);
        }
    }

    public void close() {
        this.zkClient.close();
    }

    private String buildInstanceNodeName(InstanceRegisterDTO instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private class ZkStateListener
    implements IZkStateListener {
        private ZkStateListener() {
        }

        public void handleStateChanged(Watcher.Event.KeeperState keeperState) {
            if (Watcher.Event.KeeperState.SyncConnected.equals((Object)keeperState)) {
                ZookeeperInstanceRegisterRepository.this.nodeDataMap.forEach((k, v) -> {
                    if (!ZookeeperInstanceRegisterRepository.this.zkClient.exists(k)) {
                        ZookeeperInstanceRegisterRepository.this.zkClient.createEphemeral(k, v);
                        LOGGER.info("zookeeper client register success: {}", v);
                    }
                });
            }
        }

        public void handleNewSession() {
        }

        public void handleSessionEstablishmentError(Throwable throwable) {
        }
    }
}

