/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;

public final class BaseDataCache {
    private static final BaseDataCache INSTANCE = new BaseDataCache();
    private static final ConcurrentMap<String, PluginData> PLUGIN_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<SelectorData>> SELECTOR_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<RuleData>> RULE_MAP = Maps.newConcurrentMap();

    private BaseDataCache() {
    }

    public static BaseDataCache getInstance() {
        return INSTANCE;
    }

    public void cachePluginData(PluginData pluginData) {
        Optional.ofNullable(pluginData).ifPresent(data -> PLUGIN_MAP.put(data.getName(), (PluginData)data));
    }

    public void removePluginData(PluginData pluginData) {
        Optional.ofNullable(pluginData).ifPresent(data -> {
            PluginData cfr_ignored_0 = (PluginData)PLUGIN_MAP.remove(data.getName());
        });
    }

    public void removePluginDataByPluginName(String pluginName) {
        PLUGIN_MAP.remove(pluginName);
    }

    public void cleanPluginData() {
        PLUGIN_MAP.clear();
    }

    public void cleanPluginDataSelf(List<PluginData> pluginDataList) {
        pluginDataList.forEach(this::removePluginData);
    }

    public PluginData obtainPluginData(String pluginName) {
        return (PluginData)PLUGIN_MAP.get(pluginName);
    }

    public void cacheSelectData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(this::selectorAccept);
    }

    public void removeSelectData(SelectorData selectorData) {
        Optional.ofNullable(selectorData).ifPresent(data -> {
            List selectorDataList = (List)SELECTOR_MAP.get(data.getPluginName());
            Optional.ofNullable(selectorDataList).ifPresent(list -> list.removeIf(e -> e.getId().equals(data.getId())));
        });
    }

    public void removeSelectDataByPluginName(String pluginName) {
        SELECTOR_MAP.remove(pluginName);
    }

    public void cleanSelectorData() {
        SELECTOR_MAP.clear();
    }

    public void cleanSelectorDataSelf(List<SelectorData> selectorDataList) {
        selectorDataList.forEach(this::removeSelectData);
    }

    public List<SelectorData> obtainSelectorData(String pluginName) {
        return (List)SELECTOR_MAP.get(pluginName);
    }

    public void cacheRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(this::ruleAccept);
    }

    public void removeRuleData(RuleData ruleData) {
        Optional.ofNullable(ruleData).ifPresent(data -> {
            List ruleDataList = (List)RULE_MAP.get(data.getSelectorId());
            Optional.ofNullable(ruleDataList).ifPresent(list -> list.removeIf(rule -> rule.getId().equals(data.getId())));
        });
    }

    public void removeRuleDataBySelectorId(String selectorId) {
        RULE_MAP.remove(selectorId);
    }

    public void cleanRuleData() {
        RULE_MAP.clear();
    }

    public void cleanRuleDataSelf(List<RuleData> ruleDataList) {
        ruleDataList.forEach(this::removeRuleData);
    }

    public List<RuleData> obtainRuleData(String selectorId) {
        return (List)RULE_MAP.get(selectorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ruleAccept(RuleData data) {
        String selectorId = data.getSelectorId();
        ConcurrentMap<String, List<RuleData>> concurrentMap = RULE_MAP;
        synchronized (concurrentMap) {
            if (RULE_MAP.containsKey(selectorId)) {
                List existList = (List)RULE_MAP.get(selectorId);
                List resultList = existList.stream().filter(r -> !r.getId().equals(data.getId())).collect(Collectors.toList());
                resultList.add(data);
                List collect = resultList.stream().sorted(Comparator.comparing(RuleData::getSort)).collect(Collectors.toList());
                RULE_MAP.put(selectorId, collect);
            } else {
                RULE_MAP.put(selectorId, Lists.newArrayList((Object[])new RuleData[]{data}));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectorAccept(SelectorData data) {
        String key = data.getPluginName();
        ConcurrentMap<String, List<SelectorData>> concurrentMap = SELECTOR_MAP;
        synchronized (concurrentMap) {
            if (SELECTOR_MAP.containsKey(key)) {
                List existList = (List)SELECTOR_MAP.get(key);
                List resultList = existList.stream().filter(r -> !r.getId().equals(data.getId())).collect(Collectors.toList());
                resultList.add(data);
                List collect = resultList.stream().sorted(Comparator.comparing(SelectorData::getSort)).collect(Collectors.toList());
                SELECTOR_MAP.put(key, collect);
            } else {
                SELECTOR_MAP.put(key, Lists.newArrayList((Object[])new SelectorData[]{data}));
            }
        }
    }
}

