/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.springcloud.loadbalance;

import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.convert.selector.SpringCloudSelectorHandle;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.plugin.springcloud.handler.SpringCloudPluginDataHandler;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKey;
import org.apache.shenyu.plugin.springcloud.loadbalance.LoadBalanceKeyHolder;

public class LoadBalanceRule
extends ZoneAvoidanceRule {
    public Server choose(Object key) {
        LoadBalanceKey loadBalanceKey = LoadBalanceKeyHolder.getLoadBalanceKey();
        List available = this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
        if (CollectionUtils.isEmpty((Collection)available)) {
            return null;
        }
        SpringCloudSelectorHandle springCloudSelectorHandle = (SpringCloudSelectorHandle)SpringCloudPluginDataHandler.SELECTOR_CACHED.get().obtainHandle((Object)loadBalanceKey.getSelectorId());
        if (!springCloudSelectorHandle.getGray()) {
            return super.choose(key);
        }
        List divideUpstreams = UpstreamCacheManager.getInstance().findUpstreamListBySelectorId(loadBalanceKey.getSelectorId());
        if (CollectionUtils.isEmpty((Collection)divideUpstreams)) {
            return super.choose(key);
        }
        ArrayList choose = new ArrayList(available.size());
        for (Server server2 : available) {
            divideUpstreams.stream().filter(Upstream::isStatus).filter(upstream -> upstream.getUrl().equals(server2.getHostPort())).findFirst().ifPresent(choose::add);
        }
        if (CollectionUtils.isEmpty(choose)) {
            return super.choose(key);
        }
        Upstream upstream2 = LoadBalancerFactory.selector(choose, (String)loadBalanceKey.getLoadBalance(), (String)loadBalanceKey.getIp());
        return available.stream().filter(server -> server.getHostPort().equals(upstream2.getUrl())).findFirst().orElse(null);
    }
}

