/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginDataRefresh
extends AbstractDataRefresh<PluginData> {
    private static final Logger LOG = LoggerFactory.getLogger(PluginDataRefresh.class);
    private final PluginDataSubscriber pluginDataSubscriber;

    public PluginDataRefresh(PluginDataSubscriber pluginDataSubscriber) {
        this.pluginDataSubscriber = pluginDataSubscriber;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.PLUGIN.name());
    }

    @Override
    protected ConfigData<PluginData> fromJson(JsonObject data) {
        return (ConfigData)GSON.fromJson((JsonElement)data, new TypeToken<ConfigData<PluginData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<PluginData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.PLUGIN);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.PLUGIN);
    }

    @Override
    protected void refresh(List<PluginData> data) {
        this.pluginDataSubscriber.refreshPluginDataAll();
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all plugin data cache");
            return;
        }
        data.forEach(arg_0 -> ((PluginDataSubscriber)this.pluginDataSubscriber).onSubscribe(arg_0));
    }
}

