/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sync.data.http.refresh;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.http.refresh.AbstractDataRefresh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppAuthDataRefresh
extends AbstractDataRefresh<AppAuthData> {
    private static final Logger LOG = LoggerFactory.getLogger(AppAuthDataRefresh.class);
    private final List<AuthDataSubscriber> authDataSubscribers;

    public AppAuthDataRefresh(List<AuthDataSubscriber> authDataSubscribers) {
        this.authDataSubscribers = authDataSubscribers;
    }

    @Override
    protected JsonObject convert(JsonObject data) {
        return data.getAsJsonObject(ConfigGroupEnum.APP_AUTH.name());
    }

    @Override
    protected ConfigData<AppAuthData> fromJson(JsonObject data) {
        return (ConfigData)GSON.fromJson((JsonElement)data, new TypeToken<ConfigData<AppAuthData>>(){}.getType());
    }

    @Override
    protected boolean updateCacheIfNeed(ConfigData<AppAuthData> result) {
        return this.updateCacheIfNeed(result, ConfigGroupEnum.APP_AUTH);
    }

    @Override
    public ConfigData<?> cacheConfigData() {
        return (ConfigData)GROUP_CACHE.get(ConfigGroupEnum.APP_AUTH);
    }

    @Override
    protected void refresh(List<AppAuthData> data) {
        if (CollectionUtils.isEmpty(data)) {
            LOG.info("clear all appAuth data cache");
            this.authDataSubscribers.forEach(AuthDataSubscriber::refresh);
        } else {
            data.forEach(authData -> this.authDataSubscribers.forEach(subscriber -> subscriber.onSubscribe(authData)));
        }
    }
}

