/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.loadbalancer.spi;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.IntStream;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.spi.AbstractLoadBalancer;
import org.apache.shenyu.spi.Join;

@Join
public class HashLoadBalancer
extends AbstractLoadBalancer {
    private static final int VIRTUAL_NODE_NUM = 5;

    @Override
    public Upstream doSelect(List<Upstream> upstreamList, String ip) {
        ConcurrentSkipListMap treeMap = new ConcurrentSkipListMap();
        upstreamList.stream().forEach(upstream -> IntStream.range(0, 5).forEach(i -> {
            long addressHash = HashLoadBalancer.hash("SHENYU-" + upstream.getUrl() + "-HASH-" + i);
            treeMap.put(addressHash, upstream);
        }));
        long hash = HashLoadBalancer.hash(ip);
        SortedMap lastRing = treeMap.tailMap((Object)hash);
        if (!lastRing.isEmpty()) {
            return (Upstream)lastRing.get(lastRing.firstKey());
        }
        return (Upstream)treeMap.firstEntry().getValue();
    }

    private static long hash(String key) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 not supported", e);
        }
        md5.reset();
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        md5.update(keyBytes);
        byte[] digest = md5.digest();
        long hashCode = (long)(digest[3] & 0xFF) << 24 | (long)(digest[2] & 0xFF) << 16 | (long)(digest[1] & 0xFF) << 8 | (long)(digest[0] & 0xFF);
        return hashCode & 0xFFFFFFFFL;
    }
}

