/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.autoconfigure;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.monitor.IntegrationMBeanExporter;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={IntegrationMBeanExporter.class})
class RestartEndpointWithIntegrationConfiguration {
    @Autowired(required=false)
    private IntegrationMBeanExporter exporter;

    RestartEndpointWithIntegrationConfiguration() {
    }

    @Bean
    @ConditionalOnAvailableEndpoint
    @ConditionalOnMissingBean
    public RestartEndpoint restartEndpoint() {
        RestartEndpoint endpoint = new RestartEndpoint();
        if (this.exporter != null) {
            endpoint.setIntegrationMBeanExporter(this.exporter);
        }
        return endpoint;
    }
}

