/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.web.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.NonNull;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class FallbackFilter
implements WebFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FallbackFilter.class);
    private static final AntPathMatcher MATCHER = new AntPathMatcher();
    private static final String HYSTRIX = "/fallback/hystrix";
    private static final String RESILIENCE4J = "/fallback/resilience4j";
    private final Set<String> paths;

    public FallbackFilter(List<String> paths) {
        this.paths = CollectionUtils.isNotEmpty(paths) ? new HashSet<String>(paths) : new HashSet<String>();
        this.paths.add(HYSTRIX);
        this.paths.add(RESILIENCE4J);
    }

    @NonNull
    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getURI().getPath();
        Set<String> fallbackPaths = Collections.unmodifiableSet(this.paths);
        boolean match = fallbackPaths.stream().anyMatch(url -> FallbackFilter.reg(url, path));
        if (match) {
            Object error = this.getError(exchange, path);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        return chain.filter(exchange);
    }

    private static boolean reg(String pattern, String path) {
        return MATCHER.match(pattern, path);
    }

    private Object getError(ServerWebExchange exchange, String path) {
        if (HYSTRIX.equals(path)) {
            LOG.error("the fallback for hystrix");
            return ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.HYSTRIX_PLUGIN_FALLBACK, null);
        }
        if (RESILIENCE4J.equals(path)) {
            LOG.error("the fallback for resilience4j");
            return ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.RESILIENCE4J_PLUGIN_FALLBACK, null);
        }
        return ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.DEFAULT_FALLBACK, null);
    }
}

