/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.sync.data.zookeeper;

import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.ZkClient;
import org.apache.shenyu.springboot.sync.data.zookeeper.ZookeeperConfig;
import org.apache.shenyu.sync.data.api.AuthDataSubscriber;
import org.apache.shenyu.sync.data.api.MetaDataSubscriber;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.apache.shenyu.sync.data.api.SyncDataService;
import org.apache.shenyu.sync.data.zookeeper.ZookeeperSyncDataService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={ZookeeperSyncDataService.class})
@ConditionalOnProperty(prefix="shenyu.sync.zookeeper", name={"url"})
@EnableConfigurationProperties(value={ZookeeperConfig.class})
public class ZookeeperSyncDataConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZookeeperSyncDataConfiguration.class);

    @Bean
    public SyncDataService syncDataService(ObjectProvider<ZkClient> zkClient, ObjectProvider<PluginDataSubscriber> pluginSubscriber, ObjectProvider<List<MetaDataSubscriber>> metaSubscribers, ObjectProvider<List<AuthDataSubscriber>> authSubscribers) {
        LOGGER.info("you use zookeeper sync shenyu data.......");
        return new ZookeeperSyncDataService((ZkClient)zkClient.getIfAvailable(), (PluginDataSubscriber)pluginSubscriber.getIfAvailable(), (List)metaSubscribers.getIfAvailable(Collections::emptyList), (List)authSubscribers.getIfAvailable(Collections::emptyList));
    }

    @Bean
    public ZkClient zkClient(ZookeeperConfig zookeeperConfig) {
        return new ZkClient(zookeeperConfig.getUrl(), zookeeperConfig.getSessionTimeout().intValue(), zookeeperConfig.getConnectionTimeout().intValue());
    }
}

