/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.resilience4j.handler;

import java.util.Optional;
import java.util.function.Supplier;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.convert.rule.Resilience4JHandle;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.resilience4j.factory.Resilience4JRegistryFactory;

public class Resilience4JHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, Resilience4JHandle>> CACHED_HANDLE = new BeanHolder(CommonHandleCache::new);

    public void handlerRule(RuleData ruleData) {
        String key = CacheKeyUtils.INST.getKey(ruleData);
        Resilience4JRegistryFactory.remove(key);
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            Resilience4JHandle resilience4JHandle = (Resilience4JHandle)GsonUtils.getInstance().fromJson(s, Resilience4JHandle.class);
            CACHED_HANDLE.get().cachedHandle((Object)key, (Object)resilience4JHandle);
        });
    }

    public void removeRule(RuleData ruleData) {
        String key = CacheKeyUtils.INST.getKey(ruleData);
        Resilience4JRegistryFactory.remove(key);
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> CACHED_HANDLE.get().removeHandle((Object)key));
    }

    public String pluginNamed() {
        return PluginEnum.RESILIENCE4J.getName();
    }
}

