/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.context;

import com.qq.tars.context.DistributedContext;
import com.qq.tars.context.DistributedContextCodec;
import com.qq.tars.context.exc.CodecException;
import com.qq.tars.context.impl.DistributedContextImpl;
import java.util.Map;

public class DistributedContextManager {
    private static final DistributedContext context = new DistributedContextImpl();
    private static DistributedContextCodec _codec;

    private static boolean canCodec() {
        return _codec != null;
    }

    public static DistributedContext getDistributedContext() {
        return context;
    }

    public static void releaseDistributedContext() {
        DistributedContextManager.getDistributedContext().clear();
    }

    public static void setDistributedContextCodec(DistributedContextCodec codec) {
        _codec = codec;
    }

    public static byte[] serializeContext2Bytes() throws CodecException {
        if (DistributedContextManager.canCodec()) {
            return _codec.context2Bytes(DistributedContextManager.getDistributedContext().getAttributes());
        }
        throw new CodecException("codec is null");
    }

    public static void deserializeBytes2Context(byte[] src) throws CodecException {
        if (DistributedContextManager.canCodec()) {
            Map<String, Object> attributes = _codec.loadBytes(src);
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                DistributedContextManager.getDistributedContext().put(attribute.getKey(), attribute.getValue());
            }
        } else {
            throw new CodecException("codec is null");
        }
    }

    public static String serializeContext2String() throws CodecException {
        if (DistributedContextManager.canCodec()) {
            return _codec.context2String(DistributedContextManager.getDistributedContext().getAttributes());
        }
        throw new CodecException("codec is null");
    }

    public static void deserializeString2Context(String src) throws CodecException {
        if (DistributedContextManager.canCodec()) {
            Map<String, Object> attributes = _codec.loadString(src);
            for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                DistributedContextManager.getDistributedContext().put(attribute.getKey(), attribute.getValue());
            }
        } else {
            throw new CodecException("codec is null");
        }
    }
}

