/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.response.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyClientMessageWriter
implements MessageWriter {
    private final List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, MediaType.APPLICATION_STREAM_JSON);

    @Override
    public Mono<Void> writeWith(ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange).doOnError(throwable -> this.cleanup(exchange)).then(Mono.defer(() -> {
            Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
            if (Objects.isNull(connection)) {
                return Mono.empty();
            }
            ServerHttpResponse response = exchange.getResponse();
            NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
            Flux body = connection.inbound().receive().retain().map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
            MediaType contentType = response.getHeaders().getContentType();
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
        })).doOnCancel(() -> this.cleanup(exchange));
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
        if (Objects.nonNull(connection)) {
            connection.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (!Objects.nonNull(contentType)) return false;
        if (!this.streamingMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) return false;
        return true;
    }
}

