/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.instance.etcd;

import java.util.Properties;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.common.dto.InstanceRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.register.instance.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.register.instance.etcd.EtcdClient;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class EtcdInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtcdInstanceRegisterRepository.class);
    private EtcdClient client;

    public void init(ShenyuConfig.InstanceConfig config) {
        Properties props = config.getProps();
        long timeout = Long.parseLong(props.getProperty("etcdTimeout", "3000"));
        long ttl = Long.parseLong(props.getProperty("etcdTTL", "5"));
        this.client = new EtcdClient(config.getServerLists(), ttl, timeout);
    }

    public void persistInstance(InstanceRegisterDTO instance) {
        String instanceNodeName = this.buildInstanceNodeName(instance);
        String instancePath = RegisterPathConstants.buildInstanceParentPath();
        String realNode = RegisterPathConstants.buildRealNode((String)instancePath, (String)instanceNodeName);
        String nodeData = GsonUtils.getInstance().toJson((Object)instance);
        this.client.putEphemeral(realNode, nodeData);
        LOGGER.info("etcd client register success: {}", (Object)nodeData);
    }

    private String buildInstanceNodeName(InstanceRegisterDTO instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    public void close() {
        this.client.close();
    }
}

