/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.plugin.tracing.common.definition;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.agent.api.entity.PointCutConfig;
import org.apache.shenyu.agent.api.point.ShenyuAgentJoinPoint;
import org.apache.shenyu.agent.api.spi.AbstractAgentPluginDefinition;
import org.apache.shenyu.agent.core.enums.PointType;
import org.apache.shenyu.agent.core.locator.ShenyuAgentLocator;
import org.apache.shenyu.agent.core.utils.ShenyuAgentConfigUtils;
import org.apache.shenyu.agent.core.yaml.ShenyuYamlEngine;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public final class TracingAgentPluginDefinition
extends AbstractAgentPluginDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(TracingAgentPluginDefinition.class);

    protected Collection<ShenyuAgentJoinPoint.JoinPointBuilder> joinPointBuilder() {
        PointCutConfig config = null;
        try {
            config = (PointCutConfig)ShenyuYamlEngine.unmarshal((File)ShenyuAgentLocator.locatorConf((String)"tracing-point.yaml"), PointCutConfig.class);
        }
        catch (IOException e) {
            LOG.error("Exception loader tracing point config is", (Throwable)e);
        }
        if (Objects.isNull(config) || config.getPointCuts().isEmpty()) {
            return Collections.emptyList();
        }
        return config.getPointCuts().stream().filter(pointCut -> StringUtils.isNotEmpty((CharSequence)pointCut.getTargetClass()) && !pointCut.getPoints().isEmpty() && !pointCut.getHandlers().isEmpty()).map(pointCut -> {
            String[] constructorPoints;
            String[] staticMethods;
            ShenyuAgentJoinPoint.JoinPointBuilder builder = ShenyuAgentJoinPoint.interceptClass((String)pointCut.getTargetClass());
            Set supports = ShenyuAgentConfigUtils.getSupports();
            List handlers = pointCut.getHandlers().entrySet().stream().filter(entry -> supports.contains(entry.getKey())).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
            String[] instanceMethods = (String[])pointCut.getPoints().stream().filter(point -> PointType.INSTANCE_METHOD.getName().equals(point.getType())).map(PointCutConfig.Point::getName).toArray(String[]::new);
            if (instanceMethods.length > 0) {
                builder.aroundInstanceMethod((ElementMatcher)ElementMatchers.namedOneOf((String[])instanceMethods)).handlers(handlers).build();
            }
            if ((staticMethods = (String[])pointCut.getPoints().stream().filter(point -> PointType.STATIC_METHOD.getName().equals(point.getType())).map(PointCutConfig.Point::getName).toArray(String[]::new)).length > 0) {
                builder.aroundStaticMethod((ElementMatcher)ElementMatchers.namedOneOf((String[])staticMethods)).handlers(handlers).build();
            }
            if ((constructorPoints = (String[])pointCut.getPoints().stream().filter(point -> PointType.CONSTRUCTOR.getName().equals(point.getType())).map(PointCutConfig.Point::getName).toArray(String[]::new)).length > 0) {
                builder.onConstructor((ElementMatcher)ElementMatchers.namedOneOf((String[])constructorPoints)).handlers(handlers).build();
            }
            return builder;
        }).collect(Collectors.toList());
    }
}

