/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.remote.gprc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.client.naming.remote.gprc.NamingGrpcClientProxy;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.remote.client.ConnectionEventListener;
import com.alibaba.nacos.common.utils.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NamingGrpcConnectionEventListener
implements ConnectionEventListener {
    private final NamingGrpcClientProxy clientProxy;
    private final ConcurrentMap<String, Set<Instance>> registeredInstanceCached = new ConcurrentHashMap<String, Set<Instance>>();
    private final Set<String> subscribes = new ConcurrentHashSet<String>();

    public NamingGrpcConnectionEventListener(NamingGrpcClientProxy clientProxy) {
        this.clientProxy = clientProxy;
    }

    @Override
    public void onConnected() {
        this.redoSubscribe();
        this.redoRegisterEachService();
    }

    private void redoSubscribe() {
        for (String each : this.subscribes) {
            ServiceInfo serviceInfo = ServiceInfo.fromKey(each);
            try {
                this.clientProxy.subscribe(serviceInfo.getName(), serviceInfo.getGroupName(), serviceInfo.getClusters());
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.warn(String.format("re subscribe service %s failed", serviceInfo.getName()), (Throwable)e);
            }
        }
    }

    private void redoRegisterEachService() {
        for (Map.Entry each : this.registeredInstanceCached.entrySet()) {
            String serviceName = NamingUtils.getServiceName((String)each.getKey());
            String groupName = NamingUtils.getGroupName((String)each.getKey());
            this.redoRegisterEachInstance(serviceName, groupName, (Set)each.getValue());
        }
    }

    private void redoRegisterEachInstance(String serviceName, String groupName, Set<Instance> instances) {
        for (Instance each : instances) {
            try {
                this.clientProxy.registerService(serviceName, groupName, each);
            }
            catch (NacosException e) {
                LogUtils.NAMING_LOGGER.warn(String.format("redo register for service %s@@%s failed", groupName, serviceName), (Throwable)e);
            }
        }
    }

    @Override
    public void onDisConnect() {
    }

    public void cacheInstanceForRedo(String serviceName, String groupName, Instance instance) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        this.registeredInstanceCached.putIfAbsent(key, new ConcurrentHashSet());
        ((Set)this.registeredInstanceCached.get(key)).add(instance);
    }

    public void removeInstanceForRedo(String serviceName, String groupName, Instance instance) {
        String key = NamingUtils.getGroupedName(serviceName, groupName);
        Set instances = (Set)this.registeredInstanceCached.get(key);
        if (null != instances) {
            instances.remove(instance);
        }
    }

    public void cacheSubscriberForRedo(String fullServiceName, String cluster) {
        this.subscribes.add(ServiceInfo.getKey(fullServiceName, cluster));
    }

    public void removeSubscriberForRedo(String fullServiceName, String cluster) {
        this.subscribes.remove(ServiceInfo.getKey(fullServiceName, cluster));
    }
}

