/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.api.exception;

import com.alibaba.nacos.api.utils.StringUtils;

public class NacosException
extends Exception {
    private static final long serialVersionUID = -3913902031489277776L;
    private int errCode;
    private String errMsg;
    private Throwable causeThrowable;
    public static final int CLIENT_INVALID_PARAM = -400;
    public static final int CLIENT_DISCONNECT = -401;
    public static final int CLIENT_OVER_THRESHOLD = -503;
    public static final int INVALID_PARAM = 400;
    public static final int NO_RIGHT = 403;
    public static final int NOT_FOUND = 404;
    public static final int CONFLICT = 409;
    public static final int SERVER_ERROR = 500;
    public static final int BAD_GATEWAY = 502;
    public static final int OVER_THRESHOLD = 503;
    public static final int INVALID_SERVER_STATUS = 300;
    public static final int UN_REGISTER = 301;
    public static final int NO_HANDLER = 302;
    public static final int RESOURCE_NOT_FOUND = -404;
    public static final int HTTP_CLIENT_ERROR_CODE = -500;

    public NacosException() {
    }

    public NacosException(int errCode, String errMsg) {
        super(errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public NacosException(int errCode, Throwable throwable) {
        super(throwable);
        this.errCode = errCode;
        this.setCauseThrowable(throwable);
    }

    public NacosException(int errCode, String errMsg, Throwable throwable) {
        super(errMsg, throwable);
        this.errCode = errCode;
        this.errMsg = errMsg;
        this.setCauseThrowable(throwable);
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        if (!StringUtils.isBlank(this.errMsg)) {
            return this.errMsg;
        }
        if (this.causeThrowable != null) {
            return this.causeThrowable.getMessage();
        }
        return "";
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setCauseThrowable(Throwable throwable) {
        this.causeThrowable = this.getCauseThrowable(throwable);
    }

    private Throwable getCauseThrowable(Throwable t) {
        if (t.getCause() == null) {
            return t;
        }
        return this.getCauseThrowable(t.getCause());
    }

    @Override
    public String toString() {
        return "ErrCode:" + this.getErrCode() + ", ErrMsg:" + this.getErrMsg();
    }
}

