/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.plugin.response;

import java.util.HashMap;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.response.ResponsePlugin;
import org.apache.shenyu.plugin.response.strategy.MessageWriter;
import org.apache.shenyu.plugin.response.strategy.NettyClientMessageWriter;
import org.apache.shenyu.plugin.response.strategy.RPCMessageWriter;
import org.apache.shenyu.plugin.response.strategy.WebClientMessageWriter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ResponsePluginConfiguration {
    @Bean
    public ShenyuPlugin responsePlugin(ObjectProvider<MessageWriter> httpWriter) {
        HashMap<String, Object> writerMap = new HashMap<String, Object>();
        MessageWriter httpWrite = (MessageWriter)httpWriter.getIfAvailable();
        RPCMessageWriter rpcWrite = new RPCMessageWriter();
        writerMap.put(RpcTypeEnum.HTTP.getName(), httpWrite);
        writerMap.put(RpcTypeEnum.SPRING_CLOUD.getName(), httpWrite);
        writerMap.put(RpcTypeEnum.DUBBO.getName(), rpcWrite);
        writerMap.put(RpcTypeEnum.SOFA.getName(), rpcWrite);
        writerMap.put(RpcTypeEnum.GRPC.getName(), rpcWrite);
        writerMap.put(RpcTypeEnum.MOTAN.getName(), rpcWrite);
        writerMap.put(RpcTypeEnum.TARS.getName(), rpcWrite);
        return new ResponsePlugin(writerMap);
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="netty")
    static class NettyClientMessageWriterConfiguration {
        NettyClientMessageWriterConfiguration() {
        }

        @Bean
        public MessageWriter nettyMessageWriter() {
            return new NettyClientMessageWriter();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"shenyu.httpclient.strategy"}, havingValue="webClient", matchIfMissing=true)
    static class WebClientMessageWriterConfiguration {
        WebClientMessageWriterConfiguration() {
        }

        @Bean
        public MessageWriter webClientMessageWriter() {
            return new WebClientMessageWriter();
        }
    }
}

