/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.metrics.facade;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.shenyu.metrics.config.MetricsConfig;
import org.apache.shenyu.metrics.spi.MetricsBootService;
import org.apache.shenyu.metrics.spi.MetricsRegister;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricsTrackerFacade
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsTrackerFacade.class);
    private MetricsBootService metricsBootService;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);

    private MetricsTrackerFacade() {
    }

    public static MetricsTrackerFacade getInstance() {
        return MetricsTrackerFacadeHolder.INSTANCE;
    }

    public void start(MetricsConfig metricsConfig) {
        if (this.isStarted.compareAndSet(false, true)) {
            this.metricsBootService = (MetricsBootService)ExtensionLoader.getExtensionLoader(MetricsBootService.class).getJoin(metricsConfig.getMetricsName());
            Preconditions.checkNotNull((Object)this.metricsBootService, (String)"Can not find metrics tracker manager with metrics name : %s in metrics configuration.", (Object)metricsConfig.getMetricsName());
            MetricsRegister metricsRegister = (MetricsRegister)ExtensionLoader.getExtensionLoader(MetricsRegister.class).getJoin(metricsConfig.getMetricsName());
            Preconditions.checkNotNull((Object)metricsRegister, (String)"Can not find metrics register with metrics name : %s in metrics configuration.", (Object)metricsConfig.getMetricsName());
            this.metricsBootService.start(metricsConfig, metricsRegister);
        } else {
            LOG.info("metrics tracker has started !");
        }
    }

    public void stop() {
        this.isStarted.compareAndSet(true, false);
        if (Objects.nonNull(this.metricsBootService)) {
            this.metricsBootService.stop();
        }
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    @Override
    public void close() {
        this.stop();
    }

    private static class MetricsTrackerFacadeHolder {
        private static final MetricsTrackerFacade INSTANCE = new MetricsTrackerFacade();

        private MetricsTrackerFacadeHolder() {
        }
    }
}

