/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class LoggingPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingPlugin.class);

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        ServerHttpRequest request = exchange.getRequest();
        StringBuilder requestInfo = new StringBuilder("Print Request Info: ").append(System.lineSeparator());
        requestInfo.append(this.getRequestUri(request)).append(this.getRequestMethod(request)).append(System.lineSeparator()).append(this.getRequestHeaders(request)).append(System.lineSeparator()).append(this.getQueryParams(request)).append(System.lineSeparator());
        return chain.execute(exchange.mutate().request((ServerHttpRequest)new LoggingServerHttpRequest(request, requestInfo)).response((ServerHttpResponse)new LoggingServerHttpResponse(exchange.getResponse(), requestInfo)).build());
    }

    public int getOrder() {
        return PluginEnum.LOGGING.getCode();
    }

    public String named() {
        return PluginEnum.LOGGING.getName();
    }

    private String getRequestMethod(ServerHttpRequest request) {
        return "Request Method: " + request.getMethod() + System.lineSeparator();
    }

    private String getRequestUri(ServerHttpRequest request) {
        return "Request Uri: " + request.getURI() + System.lineSeparator();
    }

    private String getQueryParams(ServerHttpRequest request) {
        MultiValueMap params = request.getQueryParams();
        StringBuilder logInfo = new StringBuilder();
        if (!params.isEmpty()) {
            logInfo.append("[Query Params Start]").append(System.lineSeparator());
            params.forEach((key, value) -> logInfo.append((String)key).append(": ").append(StringUtils.join((Iterable)value, (String)",")).append(System.lineSeparator()));
            logInfo.append("[Query Params End]").append(System.lineSeparator());
        }
        return logInfo.toString();
    }

    private String getRequestHeaders(ServerHttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        StringBuilder logInfo = new StringBuilder();
        if (!headers.isEmpty()) {
            logInfo.append("[Request Headers Start]").append(System.lineSeparator());
            logInfo.append(this.getHeaders(headers));
            logInfo.append("[Request Headers End]").append(System.lineSeparator());
        }
        return logInfo.toString();
    }

    private void print(String info) {
        LOG.info(info);
    }

    private String getHeaders(HttpHeaders headers) {
        StringBuilder sb = new StringBuilder();
        Set entrySet = headers.entrySet();
        entrySet.forEach(entry -> {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            sb.append(key).append(": ").append(StringUtils.join((Iterable)value, (String)",")).append(System.lineSeparator());
        });
        return sb.toString();
    }

    static class BodyWriter {
        private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.stream);
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        BodyWriter() {
        }

        void write(ByteBuffer buffer) {
            if (!this.isClosed.get()) {
                try {
                    this.channel.write(buffer);
                }
                catch (IOException e) {
                    this.isClosed.compareAndSet(false, true);
                    LOG.error("Parse Failed.", (Throwable)e);
                }
            }
        }

        boolean isEmpty() {
            return this.stream.size() == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String output() {
            try {
                this.isClosed.compareAndSet(false, true);
                String string = new String(this.stream.toByteArray(), StandardCharsets.UTF_8);
                return string;
            }
            catch (Exception e) {
                LOG.error("Write failed: ", (Throwable)e);
                String string = "Write failed: " + e.getMessage();
                return string;
            }
            finally {
                try {
                    this.stream.close();
                }
                catch (IOException e) {
                    LOG.error("Close stream error: ", (Throwable)e);
                }
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOG.error("Close channel error: ", (Throwable)e);
                }
            }
        }
    }

    class LoggingServerHttpResponse
    extends ServerHttpResponseDecorator {
        private final StringBuilder logInfo;
        private final ServerHttpResponse serverHttpResponse;

        LoggingServerHttpResponse(ServerHttpResponse delegate, StringBuilder logInfo) {
            super(delegate);
            this.logInfo = logInfo;
            this.serverHttpResponse = delegate;
            this.logInfo.append(System.lineSeparator());
        }

        @NonNull
        public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
            return super.writeWith(this.appendResponse(body));
        }

        @NonNull
        private Flux<? extends DataBuffer> appendResponse(Publisher<? extends DataBuffer> body) {
            this.logInfo.append(System.lineSeparator());
            this.logInfo.append("Response Code: ").append(this.serverHttpResponse.getStatusCode()).append(System.lineSeparator());
            this.logInfo.append(this.getResponseHeaders()).append(System.lineSeparator());
            BodyWriter writer = new BodyWriter();
            return Flux.from(body).doOnNext(buffer -> writer.write(buffer.asByteBuffer().asReadOnlyBuffer())).doFinally(signal -> {
                this.logInfo.append("[Response Body Start]").append(System.lineSeparator());
                this.logInfo.append(writer.output()).append(System.lineSeparator());
                this.logInfo.append("[Response Body End]").append(System.lineSeparator());
                LoggingPlugin.this.print(this.logInfo.toString());
            });
        }

        private String getResponseHeaders() {
            return System.lineSeparator() + "[Response Headers Start]" + System.lineSeparator() + LoggingPlugin.this.getHeaders(this.serverHttpResponse.getHeaders()) + "[Response Headers End]" + System.lineSeparator();
        }
    }

    static class LoggingServerHttpRequest
    extends ServerHttpRequestDecorator {
        private final StringBuilder logInfo;

        LoggingServerHttpRequest(ServerHttpRequest delegate, StringBuilder logInfo) {
            super(delegate);
            this.logInfo = logInfo;
        }

        @NonNull
        public Flux<DataBuffer> getBody() {
            BodyWriter writer = new BodyWriter();
            return super.getBody().doOnNext(dataBuffer -> writer.write(dataBuffer.asByteBuffer().asReadOnlyBuffer())).doFinally(signal -> {
                if (!writer.isEmpty()) {
                    this.logInfo.append("[Request Body Start]").append(System.lineSeparator());
                    this.logInfo.append(writer.output()).append(System.lineSeparator());
                    this.logInfo.append("[Request Body End]").append(System.lineSeparator());
                } else {
                    writer.output();
                }
            });
        }
    }
}

