/*
 * Decompiled with CFR 0.152.
 */
package brave.test.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.propagation.Propagation;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public abstract class PropagationTest<K> {
    protected Map<K, String> map = new LinkedHashMap<K, String>();
    MapEntry<K> mapEntry = new MapEntry();
    TraceContext rootSpan = TraceContext.newBuilder().traceId(1L).spanId(1L).sampled(true).build();
    TraceContext childSpan = this.rootSpan.toBuilder().parentId(this.rootSpan.spanId()).spanId(2L).build();

    protected abstract Propagation<K> propagation();

    protected abstract void inject(Map<K, String> var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable Boolean var5, @Nullable Boolean var6);

    protected abstract void inject(Map<K, String> var1, SamplingFlags var2);

    @Test
    public void verifyRoundTrip_rootSpan() throws Exception {
        this.inject(this.map, "0000000000000001", null, "0000000000000001", true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan));
    }

    @Test
    public void verifyRoundTrip_128BitTrace() throws Exception {
        String high64Bits = "463ac35c9f6413ad";
        String low64Bits = "48485a3953bb6124";
        this.inject(this.map, high64Bits + low64Bits, null, low64Bits, true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan.toBuilder().traceIdHigh(HexCodec.lowerHexToUnsignedLong((CharSequence)high64Bits)).traceId(HexCodec.lowerHexToUnsignedLong((CharSequence)low64Bits)).spanId(HexCodec.lowerHexToUnsignedLong((CharSequence)low64Bits)).build()));
    }

    @Test
    public void verifyRoundTrip_childSpan() throws Exception {
        this.inject(this.map, "0000000000000001", "0000000000000001", "0000000000000002", true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.childSpan));
    }

    @Test
    public void verifyRoundTrip_notSampled() throws Exception {
        this.inject(this.map, "0000000000000001", "0000000000000001", "0000000000000002", false, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.childSpan.toBuilder().sampled(false).build()));
    }

    @Test
    public void verifyRoundTrip_notSampled_noIds() throws Exception {
        this.inject(this.map, null, null, null, false, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.NOT_SAMPLED));
    }

    @Test
    public void verifyRoundTrip_sampledTrueNoOtherTraceHeaders() {
        this.inject(this.map, null, null, null, true, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.SAMPLED));
    }

    @Test
    public void verifyRoundTrip_debug() {
        this.inject(this.map, null, null, null, null, true);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.DEBUG));
    }

    @Test
    public void verifyRoundTrip_empty() throws Exception {
        this.inject(this.map, null, null, null, null, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((SamplingFlags)SamplingFlags.EMPTY));
    }

    @Test
    public void verifyRoundTrip_externallyProvidedIds() {
        this.inject(this.map, "0000000000000001", null, "0000000000000001", null, null);
        this.verifyRoundTrip(TraceContextOrSamplingFlags.create((TraceContext)this.rootSpan.toBuilder().sampled(null).build()));
    }

    void verifyRoundTrip(TraceContextOrSamplingFlags expected) {
        TraceContextOrSamplingFlags extracted = this.propagation().extractor(this.mapEntry).extract(this.map);
        Assertions.assertThat((Object)extracted).isEqualTo((Object)expected);
        LinkedHashMap injected = new LinkedHashMap();
        if (expected.context() != null) {
            this.propagation().injector(this.mapEntry).inject(expected.context(), injected);
        } else {
            this.inject(injected, expected.samplingFlags());
        }
        Assertions.assertThat(this.map).isEqualTo(injected);
    }

    protected static class MapEntry<K>
    implements Propagation.Getter<Map<K, String>, K>,
    Propagation.Setter<Map<K, String>, K> {
        public void put(Map<K, String> carrier, K key, String value) {
            carrier.put(key, value);
        }

        public String get(Map<K, String> carrier, K key) {
            return carrier.get(key);
        }
    }
}

