/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.global.cache;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.utils.PathMatchUtils;

public final class MetaDataCache {
    private static final MetaDataCache INSTANCE = new MetaDataCache();
    private static final ConcurrentMap<String, MetaData> META_DATA_MAP = Maps.newConcurrentMap();

    private MetaDataCache() {
    }

    public static MetaDataCache getInstance() {
        return INSTANCE;
    }

    public void cache(MetaData data) {
        META_DATA_MAP.put(data.getPath(), data);
    }

    public void remove(MetaData data) {
        META_DATA_MAP.remove(data.getPath());
    }

    public MetaData obtain(String path) {
        return Optional.ofNullable(META_DATA_MAP.get(path)).orElseGet(() -> (MetaData)META_DATA_MAP.get(META_DATA_MAP.keySet().stream().filter(k -> PathMatchUtils.match((String)k, (String)path)).findFirst().orElse("")));
    }
}

