/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.global;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.api.context.ShenyuContextBuilder;
import org.apache.shenyu.plugin.api.context.ShenyuContextDecorator;
import org.apache.shenyu.plugin.global.GlobalPlugin;
import org.apache.shenyu.plugin.global.cache.MetaDataCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;

public class DefaultShenyuContextBuilder
implements ShenyuContextBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalPlugin.class);
    private static final String RPC_TYPE = "rpc_type";
    private static final String UPGRADE = "Upgrade";
    private final Map<String, ShenyuContextDecorator> decoratorMap;

    public DefaultShenyuContextBuilder(Map<String, ShenyuContextDecorator> decoratorMap) {
        this.decoratorMap = decoratorMap;
    }

    public ShenyuContext build(ServerWebExchange exchange) {
        String rpcType;
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getURI().getPath();
        MetaData metaData = MetaDataCache.getInstance().obtain(path);
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst(UPGRADE);
        if (Objects.nonNull(metaData) && Boolean.TRUE.equals(metaData.getEnabled())) {
            exchange.getAttributes().put("metaData", metaData);
            rpcType = metaData.getRpcType();
        } else {
            String rpcTypeParam;
            rpcType = StringUtils.isNotEmpty((CharSequence)upgrade) && RpcTypeEnum.WEB_SOCKET.getName().equals(upgrade) ? RpcTypeEnum.WEB_SOCKET.getName() : (StringUtils.isEmpty((CharSequence)(rpcTypeParam = request.getHeaders().getFirst(RPC_TYPE))) ? RpcTypeEnum.HTTP.getName() : rpcTypeParam);
        }
        return this.decoratorMap.get(rpcType).decorator(this.buildDefaultContext(request), metaData);
    }

    private ShenyuContext buildDefaultContext(ServerHttpRequest request) {
        String appKey = request.getHeaders().getFirst("appKey");
        String sign = request.getHeaders().getFirst("sign");
        String timestamp = request.getHeaders().getFirst("timestamp");
        ShenyuContext shenyuContext = new ShenyuContext();
        String path = request.getURI().getPath();
        shenyuContext.setPath(path);
        shenyuContext.setAppKey(appKey);
        shenyuContext.setSign(sign);
        shenyuContext.setTimestamp(timestamp);
        shenyuContext.setStartDateTime(LocalDateTime.now());
        Optional.ofNullable(request.getMethod()).ifPresent(httpMethod -> shenyuContext.setHttpMethod(httpMethod.name()));
        return shenyuContext;
    }
}

