/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.request;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.support.BodyInserterContext;
import org.apache.shenyu.plugin.base.support.CachedBodyOutputMessage;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.cryptor.decorator.CryptorRequestDecorator;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRequestPluginDataHandler;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategyFactory;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class CryptorRequestPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(CryptorRequestPlugin.class);
    private static final List<HttpMessageReader<?>> MESSAGE_READERS = HandlerStrategies.builder().build().messageReaders();

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        CryptorRuleHandler ruleHandle = (CryptorRuleHandler)CryptorRequestPluginDataHandler.CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(rule));
        if (Objects.isNull(ruleHandle)) {
            LOG.error("Cryptor request rule configuration is null :{}", (Object)rule.getId());
            return chain.execute(exchange);
        }
        Pair<Boolean, String> pair = JsonUtil.checkParam(ruleHandle);
        if (Boolean.TRUE.equals(pair.getLeft())) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getCode(), (String)(ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getMsg() + "[" + (String)pair.getRight() + "]"), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, MESSAGE_READERS);
        Mono mono = serverRequest.bodyToMono(String.class).switchIfEmpty(Mono.defer(() -> Mono.just((Object)""))).flatMap(originalBody -> this.strategyMatch(ruleHandle, (String)originalBody, exchange));
        BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)mono, String.class);
        CachedBodyOutputMessage outputMessage = ResponseUtils.newCachedBodyOutputMessage((ServerWebExchange)exchange);
        return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
            CryptorRequestDecorator decorator = new CryptorRequestDecorator(exchange, outputMessage);
            return chain.execute(exchange.mutate().request((ServerHttpRequest)decorator).build());
        })).onErrorResume(throwable -> ResponseUtils.release((CachedBodyOutputMessage)outputMessage, (Throwable)throwable));
    }

    public int getOrder() {
        return PluginEnum.CRYPTOR_REQUEST.getCode();
    }

    public String named() {
        return PluginEnum.CRYPTOR_REQUEST.getName();
    }

    private Mono strategyMatch(CryptorRuleHandler ruleHandle, String originalBody, ServerWebExchange exchange) {
        String parseBody = JsonUtil.parser(originalBody, ruleHandle.getFieldNames());
        if (Objects.isNull(parseBody)) {
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (int)ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getCode(), (String)(ShenyuResultEnum.CRYPTOR_REQUEST_ERROR_CONFIGURATION.getMsg() + "[fieldNames]"), null);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        }
        String modifiedBody = CryptorStrategyFactory.match(ruleHandle, parseBody);
        if (Objects.isNull(modifiedBody)) {
            return CryptorUtil.fail(ruleHandle.getWay(), exchange);
        }
        return CryptorUtil.success(originalBody, modifiedBody, ruleHandle.getWay(), ruleHandle.getFieldNames());
    }
}

