/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.decorator;

import java.util.Objects;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.strategy.CryptorStrategyFactory;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class CryptorResponseDecorator
extends ServerHttpResponseDecorator {
    private final ServerWebExchange exchange;
    private final CryptorRuleHandler ruleHandle;

    public CryptorResponseDecorator(ServerWebExchange exchange, CryptorRuleHandler ruleHandle) {
        super(exchange.getResponse());
        this.exchange = exchange;
        this.ruleHandle = ruleHandle;
    }

    @NonNull
    public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
        ClientResponse clientResponse = ResponseUtils.buildClientResponse((ServerHttpResponse)this.getDelegate(), body);
        Mono mono = clientResponse.bodyToMono(String.class).flatMap(originalBody -> this.strategyMatch((String)originalBody, this.ruleHandle, this.exchange));
        return ResponseUtils.writeWith((ClientResponse)clientResponse, (ServerWebExchange)this.exchange, (Publisher)mono, String.class);
    }

    private Mono strategyMatch(String originalBody, CryptorRuleHandler ruleHandle, ServerWebExchange exchange) {
        String parseBody = JsonUtil.parser(originalBody, ruleHandle.getFieldNames());
        if (Objects.isNull(parseBody)) {
            return Mono.just((Object)originalBody);
        }
        String modifiedBody = CryptorStrategyFactory.match(ruleHandle, parseBody);
        if (Objects.isNull(modifiedBody)) {
            return CryptorUtil.fail(ruleHandle.getWay(), exchange);
        }
        return CryptorUtil.success(originalBody, modifiedBody, ruleHandle.getWay(), ruleHandle.getFieldNames());
    }
}

