/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.agent.api.config.AgentPluginConfig;
import org.apache.shenyu.agent.api.config.ShenyuAgentConfig;
import org.apache.shenyu.agent.core.enums.SingletonHolder;
import org.apache.shenyu.agent.core.utils.GsonUtils;

public final class ShenyuAgentConfigUtils {
    public static Set<String> getSupports() {
        Map<String, List<String>> supports = ShenyuAgentConfigUtils.getConfig().getSupports();
        return supports.values().stream().flatMap(Collection::stream).filter(xva$0 -> StringUtils.isNoneEmpty(xva$0)).collect(Collectors.toSet());
    }

    public static Map<String, AgentPluginConfig> getPluginConfigMap() {
        return ShenyuAgentConfigUtils.getConfig().getPlugins().values().stream().map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, entry -> GsonUtils.getInstance().fromJson(GsonUtils.getInstance().toJson(entry.getValue()), AgentPluginConfig.class)));
    }

    public static ShenyuAgentConfig getConfig() {
        return SingletonHolder.INSTANCE.get(ShenyuAgentConfig.class);
    }

    public static void setConfig(ShenyuAgentConfig agentConfig) {
        SingletonHolder.INSTANCE.put(agentConfig);
    }
}

