/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.plugin;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shenyu.agent.api.config.AgentPluginConfig;
import org.apache.shenyu.agent.api.spi.AgentPluginBootService;
import org.apache.shenyu.agent.core.loader.SPILoader;
import org.apache.shenyu.agent.core.utils.ShenyuAgentConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginLifecycleManager {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLifecycleManager.class);

    public void startup(Map<String, AgentPluginConfig> configMap) {
        Set<String> support = ShenyuAgentConfigUtils.getSupports();
        configMap.entrySet().stream().filter(entry -> support.contains(entry.getKey())).forEach(entry -> Optional.ofNullable(SPILoader.load(AgentPluginBootService.class, (String)entry.getKey())).ifPresent(bootService -> {
            try {
                LOG.info("start shenyu plugin: {}", entry.getKey());
                bootService.start((AgentPluginConfig)entry.getValue());
            }
            catch (Throwable ex) {
                LOG.error("Failed to start shenyu plugin", ex);
            }
        }));
    }

    public void close() {
        SPILoader.loadList(AgentPluginBootService.class).forEach(each -> {
            try {
                each.close();
            }
            catch (Throwable ex) {
                LOG.error("Failed to close shenyu agent plugin", ex);
            }
        });
    }
}

