/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.locator;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

public final class ShenyuAgentLocator {
    public static File locatorAgent() {
        String classResourcePath = String.join((CharSequence)"", ShenyuAgentLocator.class.getName().replaceAll("\\.", "/"), ".class");
        URL resource = ClassLoader.getSystemClassLoader().getResource(classResourcePath);
        assert (resource != null);
        String url = resource.toString();
        int existFileInJarIndex = url.indexOf(33);
        boolean isInJar = existFileInJarIndex > -1;
        return isInJar ? ShenyuAgentLocator.getFileInJar(url, existFileInJarIndex) : ShenyuAgentLocator.getFileInResource(url, classResourcePath);
    }

    public static File locatorPlugin() {
        return new File(String.join((CharSequence)"", ShenyuAgentLocator.locatorAgent().getPath(), "/plugins"));
    }

    public static File locatorConf(String fileName) {
        return new File(String.join((CharSequence)"/", ShenyuAgentLocator.locatorAgent().getPath(), "conf", fileName));
    }

    private static File getFileInResource(String url, String classResourcePath) {
        int prefixLength = "file:".length();
        String classLocation = url.substring(prefixLength, url.length() - classResourcePath.length());
        return new File(classLocation);
    }

    private static File getFileInJar(String url, int fileInJarIndex) {
        String realUrl = url.substring(url.indexOf("file:"), fileInJarIndex);
        try {
            File agentJarFile = new File(new URL(realUrl).toURI());
            return agentJarFile.exists() ? agentJarFile.getParentFile() : null;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            return null;
        }
    }
}

