/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.loader;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.shenyu.agent.api.point.ShenyuAgentJoinPoint;
import org.apache.shenyu.agent.api.spi.AgentPluginDefinition;
import org.apache.shenyu.agent.core.bytebuddy.matcher.ShenyuAgentTypeMatcher;
import org.apache.shenyu.agent.core.loader.SPILoader;
import org.apache.shenyu.agent.core.locator.ShenyuAgentLocator;
import org.apache.shenyu.dependencies.com.google.common.collect.ImmutableMap;
import org.apache.shenyu.dependencies.com.google.common.io.ByteStreams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuAgentPluginLoader
extends ClassLoader
implements Closeable {
    private static final Logger LOG;
    private static final ShenyuAgentPluginLoader AGENT_PLUGIN_LOADER;
    private final List<PluginJar> jars = new ArrayList<PluginJar>();

    private ShenyuAgentPluginLoader() {
        super(ShenyuAgentPluginLoader.class.getClassLoader());
    }

    public static ShenyuAgentPluginLoader getInstance() {
        return AGENT_PLUGIN_LOADER;
    }

    public void loadAllPlugins() throws IOException {
        File[] jarFiles = ShenyuAgentLocator.locatorPlugin().listFiles(file -> file.getName().endsWith(".jar"));
        if (Objects.isNull(jarFiles)) {
            return;
        }
        HashMap<String, ShenyuAgentJoinPoint> pointMap = new HashMap<String, ShenyuAgentJoinPoint>();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            for (File each : jarFiles) {
                outputStream.reset();
                JarFile jar = new JarFile(each, true);
                this.jars.add(new PluginJar(jar, each));
            }
        }
        this.loadAgentPluginDefinition(pointMap);
        ImmutableMap<String, ShenyuAgentJoinPoint> joinPointMap = ImmutableMap.builder().putAll(pointMap).build();
        ShenyuAgentTypeMatcher.getInstance().setJoinPointMap(joinPointMap);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = this.classNameToPath(name);
        for (PluginJar each : this.jars) {
            ZipEntry entry = each.jarFile.getEntry(path);
            if (!Objects.nonNull(entry)) continue;
            try {
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    String packageName = name.substring(0, index);
                    this.definePackageInternal(packageName, each.jarFile.getManifest());
                }
                byte[] data = ByteStreams.toByteArray(each.jarFile.getInputStream(entry));
                return this.defineClass(name, data, 0, data.length);
            }
            catch (IOException ex) {
                LOG.error("Failed to load class {}", (Object)name, (Object)ex);
            }
        }
        throw new ClassNotFoundException(String.format("Class name is %s not found", name));
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        LinkedList<URL> resources = new LinkedList<URL>();
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                resources.add(new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name)));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return Collections.enumeration(resources);
    }

    @Override
    protected URL findResource(String name) {
        for (PluginJar each : this.jars) {
            JarEntry entry = each.jarFile.getJarEntry(name);
            if (!Objects.nonNull(entry)) continue;
            try {
                return new URL(String.format("jar:file:%s!/%s", each.sourcePath.getAbsolutePath(), name));
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return null;
    }

    @Override
    public void close() {
        for (PluginJar each : this.jars) {
            try {
                each.jarFile.close();
            }
            catch (IOException ex) {
                LOG.error("Exception occur when closing jar", (Throwable)ex);
            }
        }
    }

    private void loadAgentPluginDefinition(Map<String, ShenyuAgentJoinPoint> pointMap) {
        SPILoader.loadList(AgentPluginDefinition.class).forEach(each -> each.collector().forEach(def -> {
            String classTarget = def.getClassTarget();
            if (pointMap.containsKey(classTarget)) {
                ShenyuAgentJoinPoint pluginInterceptorPoint = (ShenyuAgentJoinPoint)pointMap.get(classTarget);
                pluginInterceptorPoint.getConstructorPoints().addAll(def.getConstructorPoints());
                pluginInterceptorPoint.getInstanceMethodPoints().addAll(def.getInstanceMethodPoints());
                pluginInterceptorPoint.getStaticMethodPoints().addAll(def.getStaticMethodPoints());
            } else {
                pointMap.put(classTarget, (ShenyuAgentJoinPoint)def);
            }
        }));
    }

    private String classNameToPath(String className) {
        return String.join((CharSequence)"", className.replace(".", "/"), ".class");
    }

    private void definePackageInternal(String packageName, Manifest manifest) {
        if (Objects.isNull(this.getPackage(packageName))) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        String specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
        String specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
        String specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
        String implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
        String implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
        String implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        this.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    static {
        ShenyuAgentPluginLoader.registerAsParallelCapable();
        LOG = LoggerFactory.getLogger(ShenyuAgentPluginLoader.class);
        AGENT_PLUGIN_LOADER = new ShenyuAgentPluginLoader();
    }

    private static class PluginJar {
        private final JarFile jarFile;
        private final File sourcePath;

        PluginJar(JarFile jarFile, File sourcePath) {
            this.jarFile = jarFile;
            this.sourcePath = sourcePath;
        }
    }
}

