/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.transformer;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shenyu.agent.api.entity.TargetObject;
import org.apache.shenyu.agent.api.handler.ConstructorHandler;
import org.apache.shenyu.agent.api.handler.InstanceMethodHandler;
import org.apache.shenyu.agent.api.handler.StaticMethodHandler;
import org.apache.shenyu.agent.api.point.ConstructorPointCut;
import org.apache.shenyu.agent.api.point.InstanceMethodPointCut;
import org.apache.shenyu.agent.api.point.ShenyuAgentJoinPoint;
import org.apache.shenyu.agent.api.point.StaticMethodPointCut;
import org.apache.shenyu.agent.core.bytebuddy.interceptor.ConstructorInterceptor;
import org.apache.shenyu.agent.core.bytebuddy.interceptor.InstanceMethodInterceptor;
import org.apache.shenyu.agent.core.bytebuddy.interceptor.StaticMethodInterceptor;
import org.apache.shenyu.agent.core.bytebuddy.matcher.ShenyuAgentTypeMatcher;
import org.apache.shenyu.agent.core.bytebuddy.transformer.ShenyuAgentTransformerPoint;
import org.apache.shenyu.dependencies.net.bytebuddy.agent.builder.AgentBuilder;
import org.apache.shenyu.dependencies.net.bytebuddy.description.method.MethodDescription;
import org.apache.shenyu.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shenyu.dependencies.net.bytebuddy.dynamic.DynamicType;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.FieldAccessor;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.MethodDelegation;
import org.apache.shenyu.dependencies.net.bytebuddy.implementation.SuperMethodCall;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatchers;
import org.apache.shenyu.dependencies.net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuAgentTransformer
implements AgentBuilder.Transformer {
    private static final String EXTRA_DATA = "_$EXTRA_DATA$_";
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuAgentTransformer.class);
    private static final ShenyuAgentTypeMatcher MATCHER = ShenyuAgentTypeMatcher.getInstance();

    @Override
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule module) {
        if (!MATCHER.containsType(typeDescription)) {
            return builder;
        }
        DynamicType.Builder<Object> result = builder.defineField(EXTRA_DATA, (Type)((Object)Object.class), 66).implement(new Type[]{TargetObject.class}).intercept(FieldAccessor.ofField(EXTRA_DATA));
        ShenyuAgentJoinPoint joinPoint = MATCHER.loadShenyuAgentJoinPoint(typeDescription);
        result = this.interceptorConstructorPoint(typeDescription, joinPoint.getConstructorPoints(), result);
        result = this.interceptorStaticMethodPoint(typeDescription, joinPoint.getStaticMethodPoints(), result);
        result = this.interceptorInstanceMethodPoint(typeDescription, joinPoint.getInstanceMethodPoints(), result);
        return result;
    }

    private DynamicType.Builder<?> interceptorConstructorPoint(TypeDescription description, Collection<ConstructorPointCut> constructorPoints, DynamicType.Builder<?> builder) {
        Collection constructorAdviceComposePoints = description.getDeclaredMethods().stream().filter(MethodDescription::isConstructor).map(each -> this.buildConstructorTransformerPoint(constructorPoints, (MethodDescription.InDefinedShape)each)).filter(Objects::nonNull).collect(Collectors.toList());
        DynamicType.Builder[] result = new DynamicType.Builder[]{builder};
        constructorAdviceComposePoints.forEach(point -> {
            try {
                result[0] = builder.constructor(ElementMatchers.is(point.getDescription())).intercept(SuperMethodCall.INSTANCE.andThen(MethodDelegation.withDefaultConfiguration().to(point.getInterceptor())));
            }
            catch (Throwable ex) {
                LOG.error("Failed to load handler class: {}", (Object)description.getTypeName(), (Object)ex);
            }
        });
        return result[0];
    }

    private ShenyuAgentTransformerPoint<? extends ConstructorInterceptor> buildConstructorTransformerPoint(Collection<ConstructorPointCut> constructorPoints, MethodDescription.InDefinedShape methodDescription) {
        List constructorPointCutList = constructorPoints.stream().filter(each -> each.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (constructorPointCutList.isEmpty()) {
            return null;
        }
        List<ConstructorHandler> handlers = constructorPointCutList.stream().flatMap(pointCut -> pointCut.getHandlers().stream()).map(handler -> (ConstructorHandler)MATCHER.getOrCreateInstance((String)handler)).filter(Objects::nonNull).collect(Collectors.toList());
        return new ShenyuAgentTransformerPoint<ConstructorInterceptor>(methodDescription, new ConstructorInterceptor(handlers));
    }

    private DynamicType.Builder<?> interceptorStaticMethodPoint(TypeDescription description, Collection<StaticMethodPointCut> pointCuts, DynamicType.Builder<?> builder) {
        Collection points = description.getDeclaredMethods().stream().filter(each -> each.isStatic() && !each.isAbstract() && !each.isSynthetic()).map(methodDescription -> this.buildStaticMethodTransformationPoint(pointCuts, (MethodDescription.InDefinedShape)methodDescription)).filter(Objects::nonNull).collect(Collectors.toList());
        return ShenyuAgentTransformer.getBuilder(description, builder, points);
    }

    private static DynamicType.Builder<?> getBuilder(TypeDescription description, DynamicType.Builder<?> builder, Collection<ShenyuAgentTransformerPoint<?>> points) {
        DynamicType.Builder[] result = new DynamicType.Builder[]{builder};
        points.forEach(point -> {
            try {
                result[0] = builder.method(ElementMatchers.is(point.getDescription())).intercept(MethodDelegation.withDefaultConfiguration().to(point.getInterceptor()));
            }
            catch (Throwable ex) {
                LOG.error("Failed to load handler class: {}", (Object)description.getTypeName(), (Object)ex);
            }
        });
        return result[0];
    }

    private ShenyuAgentTransformerPoint<?> buildStaticMethodTransformationPoint(Collection<StaticMethodPointCut> pointCuts, MethodDescription.InDefinedShape methodDescription) {
        List staticMethodPoints = pointCuts.stream().filter(point -> point.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (staticMethodPoints.isEmpty()) {
            return null;
        }
        List<StaticMethodHandler> handlers = staticMethodPoints.stream().flatMap(pointCut -> pointCut.getHandlers().stream()).map(handler -> (StaticMethodHandler)MATCHER.getOrCreateInstance((String)handler)).filter(Objects::nonNull).collect(Collectors.toList());
        return new ShenyuAgentTransformerPoint<StaticMethodInterceptor>(methodDescription, new StaticMethodInterceptor(handlers));
    }

    private DynamicType.Builder<?> interceptorInstanceMethodPoint(TypeDescription description, Collection<InstanceMethodPointCut> pointCuts, DynamicType.Builder<?> builder) {
        Collection points = description.getDeclaredMethods().stream().filter(each -> !each.isAbstract() && !each.isSynthetic()).map(each -> this.buildInstanceMethodTransformationPoint(pointCuts, (MethodDescription.InDefinedShape)each)).filter(Objects::nonNull).collect(Collectors.toList());
        return ShenyuAgentTransformer.getBuilder(description, builder, points);
    }

    private ShenyuAgentTransformerPoint<?> buildInstanceMethodTransformationPoint(Collection<InstanceMethodPointCut> pointCuts, MethodDescription.InDefinedShape methodDescription) {
        List points = pointCuts.stream().filter(point -> point.getMatcher().matches(methodDescription)).collect(Collectors.toList());
        if (points.isEmpty()) {
            return null;
        }
        List<InstanceMethodHandler> handlers = points.stream().flatMap(pointCut -> pointCut.getHandlers().stream()).map(handler -> (InstanceMethodHandler)MATCHER.getOrCreateInstance((String)handler)).filter(Objects::nonNull).collect(Collectors.toList());
        return new ShenyuAgentTransformerPoint<InstanceMethodInterceptor>(methodDescription, new InstanceMethodInterceptor(handlers));
    }
}

