/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.matcher;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.shenyu.agent.api.point.ShenyuAgentJoinPoint;
import org.apache.shenyu.agent.core.loader.ShenyuAgentPluginLoader;
import org.apache.shenyu.dependencies.net.bytebuddy.description.type.TypeDefinition;
import org.apache.shenyu.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ShenyuAgentTypeMatcher
extends ElementMatcher.Junction.AbstractBase<TypeDefinition> {
    private static final ShenyuAgentTypeMatcher SHENYU_AGENT_TYPE_MATCHER = new ShenyuAgentTypeMatcher();
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuAgentPluginLoader.class);
    private final ConcurrentHashMap<String, Object> objectPool = new ConcurrentHashMap();
    private final ReentrantLock lock = new ReentrantLock();
    private Map<String, ShenyuAgentJoinPoint> joinPointMap;

    private ShenyuAgentTypeMatcher() {
    }

    public static ShenyuAgentTypeMatcher getInstance() {
        return SHENYU_AGENT_TYPE_MATCHER;
    }

    @Override
    public boolean matches(TypeDefinition target) {
        return this.joinPointMap.containsKey(target.getTypeName());
    }

    public boolean containsType(TypeDescription target) {
        return this.joinPointMap.containsKey(target.getTypeName());
    }

    public ShenyuAgentJoinPoint loadShenyuAgentJoinPoint(TypeDescription typeDescription) {
        return this.joinPointMap.getOrDefault(typeDescription.getTypeName(), new ShenyuAgentJoinPoint("", Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getOrCreateInstance(String className) {
        if (this.objectPool.containsKey(className)) {
            return (T)this.objectPool.get(className);
        }
        this.lock.lock();
        try {
            Object inst = this.objectPool.get(className);
            if (Objects.isNull(inst)) {
                try {
                    inst = Class.forName(className, true, ShenyuAgentPluginLoader.getInstance()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                    LOG.error("can not class for name to {}, exception is {} ", (Object)className, (Object)ex.getMessage());
                    T t = null;
                    this.lock.unlock();
                    return t;
                }
                this.objectPool.put(className, inst);
            }
            Object object = inst;
            return (T)object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<String, ShenyuAgentJoinPoint> getJoinPointMap() {
        return this.joinPointMap;
    }

    public void setJoinPointMap(Map<String, ShenyuAgentJoinPoint> joinPointMap) {
        this.joinPointMap = joinPointMap;
    }
}

