/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.agent.core.bytebuddy.matcher;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.shenyu.agent.core.bytebuddy.matcher.SafeErasureMatcher;
import org.apache.shenyu.dependencies.net.bytebuddy.description.type.TypeDefinition;
import org.apache.shenyu.dependencies.net.bytebuddy.description.type.TypeDescription;
import org.apache.shenyu.dependencies.net.bytebuddy.matcher.ElementMatcher;

public class HasParentTypeMatcher
extends ElementMatcher.Junction.AbstractBase<TypeDescription> {
    private final ElementMatcher<TypeDescription.Generic> matcher;
    private final boolean interfacesOnly;

    public HasParentTypeMatcher(ElementMatcher<TypeDescription.Generic> matcher, boolean interfacesOnly) {
        this.matcher = matcher;
        this.interfacesOnly = interfacesOnly;
    }

    public static ElementMatcher.Junction<TypeDescription> hasParentType(ElementMatcher<TypeDescription> matcher) {
        return new HasParentTypeMatcher(new SafeErasureMatcher<TypeDescription.Generic>(matcher), false);
    }

    @Override
    public boolean matches(TypeDescription target) {
        HashSet<TypeDescription> checkedInterfaces = new HashSet<TypeDescription>(8);
        TypeDefinition typeDefinition = target;
        while (typeDefinition != null) {
            if ((!this.interfacesOnly || typeDefinition.isInterface()) && this.matcher.matches(typeDefinition.asGenericType()) || this.hasInterface(typeDefinition, checkedInterfaces)) {
                return true;
            }
            typeDefinition = HasParentTypeMatcher.safeGetParentClass(typeDefinition);
        }
        return false;
    }

    private boolean hasInterface(TypeDefinition typeDefinition, Set<TypeDescription> checkedInterfaces) {
        for (TypeDefinition interfaceType : HasParentTypeMatcher.safeGetInterfaces(typeDefinition)) {
            TypeDescription erasure = HasParentTypeMatcher.safeAsErasure(interfaceType);
            if (erasure == null || !checkedInterfaces.add(interfaceType.asErasure()) || !this.matcher.matches(interfaceType.asGenericType()) && !this.hasInterface(interfaceType, checkedInterfaces)) continue;
            return true;
        }
        return false;
    }

    private static Iterable<TypeDefinition> safeGetInterfaces(TypeDefinition typeDefinition) {
        return new SafeInterfaceIterator(typeDefinition);
    }

    static TypeDefinition safeGetParentClass(TypeDefinition typeDefinition) {
        try {
            return typeDefinition.getSuperClass();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HasParentTypeMatcher)) {
            return false;
        }
        HasParentTypeMatcher other = (HasParentTypeMatcher)obj;
        return this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return this.matcher.hashCode();
    }

    static TypeDescription safeAsErasure(TypeDefinition typeDefinition) {
        try {
            return typeDefinition.asErasure();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static final class SafeInterfaceIterator
    implements Iterator<TypeDefinition>,
    Iterable<TypeDefinition> {
        private final Iterator<TypeDescription.Generic> it;
        private TypeDefinition next;

        private SafeInterfaceIterator(TypeDefinition typeDefinition) {
            Iterator it = null;
            try {
                it = typeDefinition.getInterfaces().iterator();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (null != this.it && this.it.hasNext()) {
                try {
                    this.next = this.it.next();
                    return true;
                }
                catch (Throwable e) {
                    return false;
                }
            }
            return false;
        }

        @Override
        public TypeDefinition next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<TypeDefinition> iterator() {
            return this;
        }
    }
}

